/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.api.testautomation.execution.dto.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.plugin.rest.service.helper.AttachmentContentFilterHelper;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;
import org.squashtest.tm.service.internal.dto.resultimport.ExecutionResultDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;

@Component
public class ResultPostValidator
implements Validator {
    private static final String CODE_REQUIRED_ATTRIBUTE = "required attribute";
    private static final String CODE_INVALID_ATTRIBUTE = "invalid attribute";
    private static final String TESTS_ARRAY = "tests[%d]";
    private static final String ATTACHMENTS_ARRAY_PROPERTY = ".attachments[%d]";
    private static final String NAME_PROPERTY = ".name";
    private static final String CONTENT_PROPERTY = ".content";
    private static final String AUTOMATED_TEST_SUITE = "automatedTestSuite";
    private final AttachmentContentFilterHelper filterHelper;

    @Inject
    public ResultPostValidator(AttachmentContentFilterHelper filterHelper) {
        this.filterHelper = filterHelper;
    }

    public boolean supports(Class<?> clazz) {
        return ExecutionResultDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ExecutionResultDto externalPipelineResultDto = (ExecutionResultDto)target;
        Optional.ofNullable(externalPipelineResultDto.getAutomatedTestSuite()).ifPresent(suite -> this.validateAutomatedTestSuite(externalPipelineResultDto, errors));
        this.validateTests(externalPipelineResultDto, errors);
    }

    private void validateTests(ExecutionResultDto externalPipelineResultDto, Errors errors) {
        if (externalPipelineResultDto.getTests() == null || externalPipelineResultDto.getTests().isEmpty()) {
            errors.rejectValue("tests", CODE_REQUIRED_ATTRIBUTE, "The tests attribute is required");
        } else {
            int testIndex = 0;
            while (testIndex < externalPipelineResultDto.getTests().size()) {
                TestDto test = (TestDto)externalPipelineResultDto.getTests().get(testIndex);
                this.validateTest(errors, test, testIndex);
                ++testIndex;
            }
            this.checkForDuplicateReferenceDatasetTuples(externalPipelineResultDto.getTests(), errors);
        }
    }

    private void validateTest(Errors errors, TestDto test, int testIndex) {
        if (!StringUtils.hasText((String)test.getReference())) {
            errors.rejectValue(String.format(TESTS_ARRAY, testIndex) + ".reference", CODE_REQUIRED_ATTRIBUTE, "The reference attribute is required");
        }
        if (!StringUtils.hasText((String)test.getStatus())) {
            errors.rejectValue(String.format(TESTS_ARRAY, testIndex) + ".status", CODE_REQUIRED_ATTRIBUTE, "The status attribute is required");
        } else if (this.isInvalidExecutionStatus(test)) {
            errors.rejectValue(String.format(TESTS_ARRAY, testIndex) + ".status", CODE_INVALID_ATTRIBUTE, "The status attribute is invalid, allowed values are: " + String.valueOf(AutomatedExecutionExtender.getLegalStatusSetStatic().stream().map(Enum::name).toList()));
        }
        if (test.getAttachments() != null && !test.getAttachments().isEmpty()) {
            int attachmentIndex = 0;
            while (attachmentIndex < test.getAttachments().size()) {
                String attachmentName = ((AttachmentDto)test.getAttachments().get(attachmentIndex)).getName();
                String attachmentContent = ((AttachmentDto)test.getAttachments().get(attachmentIndex)).getContent();
                this.validateExecutionAttachment(errors, testIndex, attachmentName, attachmentIndex, attachmentContent);
                ++attachmentIndex;
            }
        }
    }

    private boolean isInvalidExecutionStatus(TestDto test) {
        return AutomatedExecutionExtender.getLegalStatusSetStatic().stream().map(Enum::name).noneMatch(status -> status.equals(test.getStatus()));
    }

    private void validateExecutionAttachment(Errors errors, int testIndex, String attachmentName, int attachmentIndex, String attachmentContent) {
        if (!StringUtils.hasText((String)attachmentName)) {
            this.rejectAttachment("The name attribute is required in attachments", errors, TESTS_ARRAY.formatted(testIndex), NAME_PROPERTY, attachmentIndex);
            return;
        }
        if (!this.filterHelper.isTypeAllowedForExecutionImport(attachmentName)) {
            this.rejectAttachment("The file type of the attachment is not allowed: " + attachmentName + ". Allowed types are: " + Arrays.toString(this.filterHelper.getAllowed()), errors, TESTS_ARRAY.formatted(testIndex), NAME_PROPERTY, attachmentIndex);
        }
        if (!this.filterHelper.isSizeAllowed(attachmentContent)) {
            this.rejectSize(attachmentName, attachmentContent, errors, attachmentIndex, TESTS_ARRAY.formatted(testIndex));
        }
    }

    private void checkForDuplicateReferenceDatasetTuples(List<TestDto> tests, Errors errors) {
        HashSet<CallSite> uniqueTuples = new HashSet<CallSite>();
        for (TestDto test : tests) {
            String datasetName = test.getDatasetName() != null ? test.getDatasetName() : "";
            String tuple = test.getReference() + ":" + datasetName;
            if (uniqueTuples.add((CallSite)((Object)tuple))) continue;
            errors.rejectValue(String.format(TESTS_ARRAY, tests.indexOf(test)), CODE_INVALID_ATTRIBUTE, "The reference and dataset name combination must be unique");
        }
    }

    private void validateAutomatedTestSuite(ExecutionResultDto externalPipelineResultDto, Errors errors) {
        if (externalPipelineResultDto.getAutomatedTestSuite().getAttachments() != null) {
            int attachmentIndex = 0;
            while (attachmentIndex < externalPipelineResultDto.getAutomatedTestSuite().getAttachments().size()) {
                AttachmentDto attachmentDto = (AttachmentDto)externalPipelineResultDto.getAutomatedTestSuite().getAttachments().get(attachmentIndex);
                String attachmentName = attachmentDto.getName();
                String attachmentContent = attachmentDto.getContent();
                if (!StringUtils.hasText((String)attachmentName)) {
                    errors.rejectValue(AUTOMATED_TEST_SUITE + String.format(ATTACHMENTS_ARRAY_PROPERTY, attachmentIndex) + NAME_PROPERTY, CODE_REQUIRED_ATTRIBUTE, "The name attribute is required in attachments");
                } else {
                    if (!this.filterHelper.isTypeAllowedForAutomatedSuiteImport(attachmentName)) {
                        errors.rejectValue(AUTOMATED_TEST_SUITE + String.format(ATTACHMENTS_ARRAY_PROPERTY, attachmentIndex) + NAME_PROPERTY, CODE_INVALID_ATTRIBUTE, "The file type of the attachment is not allowed: " + attachmentName + ". Allowed types are: " + Arrays.toString(this.filterHelper.getAllowedForAutomatedSuiteImport()));
                    }
                    if (!this.filterHelper.isSizeAllowed(attachmentContent)) {
                        this.rejectSize(attachmentName, attachmentContent, errors, attachmentIndex, AUTOMATED_TEST_SUITE);
                    }
                }
                ++attachmentIndex;
            }
        }
        if (externalPipelineResultDto.getAutomatedTestSuite().getStatus() != null && Arrays.stream(ExecutionStatus.values()).map(Enum::name).noneMatch(status -> status.equals(externalPipelineResultDto.getAutomatedTestSuite().getStatus()))) {
            errors.rejectValue("automatedTestSuite.status", CODE_INVALID_ATTRIBUTE, "The status attribute is invalid, allowed values are: " + String.valueOf(Arrays.stream(ExecutionStatus.values()).map(Enum::name).toList()));
        }
    }

    private void rejectSize(String attachmentName, String attachmentContent, Errors errors, int attachmentIndex, String array) {
        this.rejectAttachment("The size of the attachment is not allowed: " + attachmentName + ". Maximum allowed size is: " + String.valueOf(this.filterHelper.getMaxUploadSizeInBytes()) + " bytes, current size is: " + attachmentContent.getBytes().length + " bytes", errors, array, CONTENT_PROPERTY, attachmentIndex);
    }

    private void rejectAttachment(String message, Errors errors, String array, String property, int attachmentIndex) {
        errors.rejectValue(array + String.format(ATTACHMENTS_ARRAY_PROPERTY, attachmentIndex) + property, CODE_INVALID_ATTRIBUTE, message);
    }
}

