/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.LibraryActionWordParser;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestActionWordDto;
import org.squashtest.tm.plugin.rest.validators.EntityValidator;
import org.squashtest.tm.service.internal.repository.ActionWordDao;

@Component
public class ActionWordPostValidator
extends EntityValidator {
    private static final String ID = "id";
    private static final String PROJECT = "project";
    private static final String WORD = "word";
    private static final String PARAMETERS = "parameters";
    private static final String TEST_CASES = "testCases";
    private static final String CODE_DUPLICATE_WORD = "duplicate word";
    private static final String CODE_GENERATED_VALUE = "generated value";
    private static final String CODE_REQUIRED_ATTRIBUTE = "required attribute";
    private static final String CODE_INVALID_ATTRIBUTE = "invalid attribute";
    private static final String MESSAGE_CAN_NOT_BE_EMPTY = "This attribute cannot be empty.";
    private static final String MESSAGE_DUPLICATE_WORD = "An action word with the given word already exists.";
    private static final String MESSAGE_GENERATED_ATTRIBUTE = "This attribute is generated by database and should not be provided. If you want to update an existing action word, please do a patch request to the action word id.";
    private static final String MESSAGE_PROJECT_MANDATORY = "The project attribute is mandatory to post an action word.";
    private static final String MESSAGE_THE_ATTRIBUTE_CANNOT_BE_POSTED = "Only attributes belonging to the action word itself can be posted. The attribute %1$s cannot be posted. Use direct url to the %1$s instead.";
    @Inject
    private ActionWordDao actionWordDao;

    public boolean supports(Class<?> clazz) {
        return RestActionWordDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RestActionWordDto post = (RestActionWordDto)target;
        this.checkActionWordId(errors, post.getId());
        this.checkWordAttribute(errors);
        this.checkDuplicateWord(errors, post);
        this.checkForbiddenPostAttributes(errors, post);
        this.checkProject(errors, post);
    }

    private void checkActionWordId(Errors errors, Long actionWordId) {
        if (actionWordId != null) {
            errors.rejectValue(ID, CODE_GENERATED_VALUE, MESSAGE_GENERATED_ATTRIBUTE);
        }
    }

    private void checkWordAttribute(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)WORD, (String)CODE_REQUIRED_ATTRIBUTE, (String)MESSAGE_CAN_NOT_BE_EMPTY);
    }

    private void checkDuplicateWord(Errors errors, RestActionWordDto post) {
        LibraryActionWordParser parser;
        ActionWord postedActionWord;
        String postedToken;
        ActionWord retrievedActionWord;
        ProjectDto postedProject = post.getProject();
        String postedWord = post.getWord();
        if (postedProject != null && !StringUtils.isBlank((CharSequence)postedWord) && (retrievedActionWord = this.actionWordDao.findByTokenInCurrentProject(postedToken = (postedActionWord = (parser = new LibraryActionWordParser()).createActionWordInLibrary(post.getWord().trim())).getToken(), post.getProject().getId())) != null && postedToken.equals(retrievedActionWord.getToken())) {
            errors.rejectValue(WORD, CODE_DUPLICATE_WORD, MESSAGE_DUPLICATE_WORD);
        }
    }

    private void checkForbiddenPostAttributes(Errors errors, RestActionWordDto post) {
        if (post.getParameters() != null) {
            errors.rejectValue(PARAMETERS, CODE_INVALID_ATTRIBUTE, String.format(MESSAGE_THE_ATTRIBUTE_CANNOT_BE_POSTED, PARAMETERS));
        }
        if (post.getTestCases() != null) {
            errors.rejectValue(TEST_CASES, CODE_INVALID_ATTRIBUTE, String.format(MESSAGE_THE_ATTRIBUTE_CANNOT_BE_POSTED, TEST_CASES));
        }
    }

    private void checkProject(Errors errors, RestActionWordDto post) {
        ProjectDto project = post.getProject();
        if (project == null) {
            errors.rejectValue(PROJECT, CODE_REQUIRED_ATTRIBUTE, MESSAGE_PROJECT_MANDATORY);
        } else {
            this.checkEntityExist(errors, Project.class, project.getId());
        }
    }
}

