/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public final class PaginationUtils {
    private PaginationUtils() {
    }

    public static <T> Page<T> convertListToPage(List<T> items, Pageable pageable) {
        int total = items.size();
        int start = (int)pageable.getOffset();
        int end = Math.min(start + pageable.getPageSize(), total);
        List<Object> output = new ArrayList();
        if (start <= end) {
            output = items.subList(start, end);
        }
        return new PageImpl(output, pageable, (long)total);
    }

    public static <T> Page<T> emptyPage(Pageable pageable) {
        return new PageImpl(Collections.emptyList(), pageable, 0L);
    }
}

