/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.helper;

import org.apache.commons.io.FilenameUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.squashtest.tm.event.ConfigUpdateEvent;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.configuration.ConfigurationService;

@Component
public class AttachmentContentFilterHelper
implements ApplicationListener<ApplicationEvent> {
    private ConfigurationService config;
    private String[] allowed;
    private String[] allowedForAutomatedSuiteImport;
    private Long maxUploadSizeInBytes;

    private void updateConfig() {
        String whiteListKey = "uploadfilter.fileExtensions.whitelist";
        String whiteList = this.config.findConfiguration(whiteListKey);
        this.allowed = whiteList.split(",");
        String whiteListKeyForAutomatedSuiteImport = "uploadfilter.fileExtensions.resultImport.whitelist";
        String whiteListForAutomatedSuiteImport = this.config.findConfiguration(whiteListKeyForAutomatedSuiteImport);
        this.allowedForAutomatedSuiteImport = whiteListForAutomatedSuiteImport.split(",");
        String uploadSizeLimit = this.config.findConfiguration("uploadfilter.upload.sizeLimitInBytes");
        this.maxUploadSizeInBytes = Long.parseLong(uploadSizeLimit);
    }

    public boolean isTypeAllowed(RawAttachment upload) {
        String fileType = FilenameUtils.getExtension((String)upload.getName());
        String[] stringArray = this.allowed;
        int n = this.allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.trim().equalsIgnoreCase(fileType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isTypeAllowedForExecutionImport(String filename) {
        String fileType = FilenameUtils.getExtension((String)filename);
        String[] stringArray = this.allowed;
        int n = this.allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.trim().equalsIgnoreCase(fileType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isTypeAllowedForAutomatedSuiteImport(String filename) {
        String fileType = FilenameUtils.getExtension((String)filename);
        String[] stringArray = this.allowedForAutomatedSuiteImport;
        int n = this.allowedForAutomatedSuiteImport.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.trim().equalsIgnoreCase(fileType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSizeAllowed(String content) {
        if (content == null || content.isBlank()) {
            return true;
        }
        long size = content.getBytes().length;
        return size <= this.maxUploadSizeInBytes;
    }

    public Long getMaxUploadSizeInBytes() {
        return this.maxUploadSizeInBytes;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && this.config == null) {
            this.config = (ConfigurationService)((ContextRefreshedEvent)event).getApplicationContext().getBean(ConfigurationService.class);
        }
        if (event instanceof ConfigUpdateEvent || event instanceof ContextRefreshedEvent) {
            this.updateConfig();
        }
    }

    public String[] getAllowed() {
        return this.allowed;
    }

    public String[] getAllowedForAutomatedSuiteImport() {
        return this.allowedForAutomatedSuiteImport;
    }
}

