/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.plugin.rest.jackson.serializer.HateoasWrapperConverter;
import org.squashtest.tm.plugin.rest.jackson.serializer.TypePropertyWriter;

@JsonTypeName(value="profile")
@JsonPropertyOrder(value={"_type", "id", "name", "type", "users", "projects"})
@JsonAppend(prepend=true, props={@JsonAppend.Prop(name="_type", value=TypePropertyWriter.class)})
public class RestPartyProfileDto {
    private long id;
    private String name;
    private String type;
    @JsonSerialize(contentConverter=HateoasWrapperConverter.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Party> users;
    @JsonSerialize(contentConverter=HateoasWrapperConverter.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<GenericProject> projects;

    public RestPartyProfileDto(long id, String name, boolean isSystem, List<Party> users) {
        this(id, name, isSystem);
        this.users = users;
    }

    public RestPartyProfileDto(List<GenericProject> projects, long id, String name, boolean isSystem) {
        this(id, name, isSystem);
        this.projects = projects;
    }

    private RestPartyProfileDto(long id, String name, boolean isSystem) {
        this.id = id;
        this.name = name;
        this.type = isSystem ? "system" : "custom";
    }

    public List<Party> getUsers() {
        return this.users;
    }

    public void setUsers(List<Party> users) {
        this.users = users;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<GenericProject> getProjects() {
        return this.projects;
    }

    public void setProjects(List<GenericProject> projects) {
        this.projects = projects;
    }
}

