/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Configurable;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.jackson.deserializer.JsonCrawler;

@Configurable
public class ParameterDeserializer
extends JsonDeserializer<Parameter> {
    @Inject
    private JsonCrawler jsonCrawler;

    public Parameter deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.doDeserialize(p);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.doDeserialize(p);
    }

    private Parameter doDeserialize(JsonParser p) throws IOException {
        JsonNode descriptionNode;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        Parameter parameter = new Parameter();
        JsonNode nameNode = node.get("name");
        if (nameNode != null && StringUtils.isNotBlank((CharSequence)nameNode.textValue())) {
            parameter.setName(nameNode.textValue());
        }
        if ((descriptionNode = node.get("description")) != null && StringUtils.isNotBlank((CharSequence)descriptionNode.textValue())) {
            parameter.setDescription(descriptionNode.textValue());
        }
        return parameter;
    }
}

