/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IterationTestPlanItemDto;
import org.squashtest.tm.plugin.rest.service.RestIterationTestPlanItemService;
import org.squashtest.tm.plugin.rest.validators.IterationTestPlanItemPostValidator;

@RestApiController(value=TestPlanItem.class)
@UseDefaultRestApiConfiguration
public class RestIterationTestPlanItemController
extends BaseRestController {
    public static final String ITPI_DYNAMIC_FILTER = "*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by";
    @Inject
    private RestIterationTestPlanItemService service;
    @Inject
    private IterationTestPlanItemPostValidator iterationTestPlanItemValidator;
    @Inject
    private IterationTestPlanItemPostValidator iterationTestPlanItemPostValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @GetMapping(value={"/iteration-test-plan-items/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by")
    public ResponseEntity<EntityModel<TestPlanItem>> findIterationTestPlanItem(@PathVariable(value="id") long id) {
        TestPlanItem itpi = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)itpi);
        this.linksHelper.addAllLinksForIterationTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/iteration-test-plan-items/{id}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="name, execution_order, execution_status, last_executed_by, last_executed_on")
    public ResponseEntity<PagedModel<EntityModel<Execution>>> findItpiExecutions(@PathVariable(value="id") long itpiId, Pageable pageable) {
        Page<Execution> execs = this.service.findExecutions(itpiId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(execs, "executions");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/iteration-test-plan-items/{id}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events, -test_plan_item")
    public ResponseEntity<EntityModel<Execution>> createNewExecution(@PathVariable(value="id") long itpiId) {
        Execution exec = this.service.createExecution(itpiId);
        EntityModel res = this.toEntityModel((Identified)exec);
        this.linksHelper.addAllLinksForExecution((EntityModel<Execution>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @GetMapping(value={"/iteration-test-plan-items"}, params={"remote_key", "server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="id")
    public ResponseEntity<PagedModel<EntityModel<TestPlanItem>>> findItemsByCoveredRemoteRequirement(@RequestParam(value="remote_key") String remoteKey, @RequestParam(value="server_name") String serverName, Pageable pageable) {
        Page<TestPlanItem> items = this.service.findItemsByCoveredRemoteRequirement(pageable, remoteKey, serverName);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(items, "iteration-test-plan-items");
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/iteration-test-plan-items/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by")
    public ResponseEntity<EntityModel<TestPlanItem>> modifyTestPlanItemToCampaign(@RequestBody IterationTestPlanItemDto itpiDto, @PathVariable(value="id") long testPlanId) throws BindException {
        this.iterationTestPlanItemValidator.validatePatchTestPlanItem(itpiDto, testPlanId);
        TestPlanItem itpi = this.service.modifyIterationTestPlan(itpiDto, testPlanId);
        EntityModel res = this.toEntityModel((Identified)itpi);
        this.linksHelper.addAllLinksForIterationTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/iteration-test-plan-items/{testPlanItemsIds}"})
    public ResponseEntity<Void> removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds) {
        this.service.deleteIterationTestPlan(testPlanItemsIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/iterations/{iterationId}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*,iteration-test-plan-item, referenced_test_case, referenced_dataset ")
    public ResponseEntity<EntityModel<TestPlanItem>> addTestCasesToIteration(@RequestBody IterationTestPlanItemDto testPlanItemDto, @PathVariable(value="iterationId") long iterationId) throws BindException {
        this.iterationTestPlanItemPostValidator.validatePostTestPlanItem(testPlanItemDto, iterationId);
        TestPlanItem itp = this.service.addIterationTestPlanItem(testPlanItemDto, iterationId);
        EntityModel res = this.toEntityModel((Identified)itp);
        this.linksHelper.addAllLinksForIterationTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }
}

