/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.plugin.rest.controller.RestAbstractExecutionOrderController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.internal.dto.AutomatedTestPlanDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestExtendedDTO;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.testautomation.testplanretriever.AllCustomFieldValuesForExec;

@UseDefaultRestApiConfiguration
@RestApiController
public class RestExecutionOrderUltimateControllerRest
extends RestAbstractExecutionOrderController<TriggerRequestExtendedDTO, AllCustomFieldValuesForExec> {
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;

    @Override
    @PostMapping(path={"/premium-trigger-iteration-automated-test"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<AutomatedTestPlanDTO> triggerIterationExecutionOrder(@RequestBody TriggerRequestExtendedDTO triggerRequest) throws BindException {
        if (!this.ultimateLicenseService.isAvailable()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).build();
        }
        return this.getIterationResponse(triggerRequest);
    }

    @Override
    @PostMapping(path={"/premium-trigger-test-suite-automated-test"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<AutomatedTestPlanDTO> triggerTestSuiteExecutionOrder(@RequestBody TriggerRequestExtendedDTO triggerRequest) throws BindException {
        if (!this.ultimateLicenseService.isAvailable()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).build();
        }
        return this.getTestSuiteResponse(triggerRequest);
    }
}

