/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.dto.AutomatedTestPlanDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestDTO;
import org.squashtest.tm.service.testautomation.testplanretriever.CustomFieldValuesForExec;
import org.squashtest.tm.service.testautomation.testplanretriever.RestTestPlanFinder;
import org.squashtest.tm.service.testautomation.testplanretriever.TestPlanRetrievalService;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.InvalidParameterException;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.NoITPIFoundException;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.NotFoundTargetUUIDException;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.TestPlanException;
import org.squashtest.tm.service.testautomation.testplanretriever.validator.TriggerRequestValidator;

public abstract class RestAbstractExecutionOrderController<T extends TriggerRequestDTO, C extends CustomFieldValuesForExec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAbstractExecutionOrderController.class);
    private static final String TRIGGER_ITERATION = "trigger-iteration";
    private static final String TRIGGER_TEST_SUITE = "trigger-test-suite";
    private static final Map<String, String> TRIGGER_TYPE_FOR_ERROR_MESSAGES = Map.of("trigger-iteration", "an iteration", "trigger-test-suite", "a test suite");
    @Inject
    protected TestPlanRetrievalService<T, C> tpRetrievalService;
    @Inject
    protected TriggerRequestValidator triggerRequestValidator;
    @Inject
    protected RestTestPlanFinder restTestPlanFinder;

    public abstract ResponseEntity<AutomatedTestPlanDTO> triggerIterationExecutionOrder(T var1) throws BindException;

    public abstract ResponseEntity<AutomatedTestPlanDTO> triggerTestSuiteExecutionOrder(T var1) throws BindException;

    protected ResponseEntity<AutomatedTestPlanDTO> getIterationResponse(T triggerRequest) throws BindException {
        ResponseEntity response;
        String uuid = triggerRequest.getTargetUUID();
        LOGGER.debug("Got request for iteration {}", (Object)uuid);
        this.validateTriggerRequest(triggerRequest, TRIGGER_ITERATION);
        try {
            Iteration iteration = this.restTestPlanFinder.findIterationByUuid(uuid);
            List itemTestPlanIds = this.restTestPlanFinder.getItemTestPlanIdsByIterationUuid(uuid);
            AutomatedTestPlanDTO testPlan = this.tpRetrievalService.getIterationTestPlan(triggerRequest, iteration, itemTestPlanIds);
            response = ResponseEntity.ok((Object)testPlan);
        }
        catch (TestPlanException ex) {
            response = this.handleTestPlanException(ex, triggerRequest, TRIGGER_ITERATION);
        }
        return response;
    }

    protected ResponseEntity<AutomatedTestPlanDTO> getTestSuiteResponse(T triggerRequest) throws BindException {
        ResponseEntity response;
        String uuid = triggerRequest.getTargetUUID();
        LOGGER.debug("Got request for test suite {}", (Object)uuid);
        this.validateTriggerRequest(triggerRequest, TRIGGER_TEST_SUITE);
        try {
            TestSuite suite = this.restTestPlanFinder.findTestSuiteByUuid(uuid);
            List itemTestPlanIds = this.restTestPlanFinder.getItemTestPlanIdsByTestSuiteUuid(uuid);
            AutomatedTestPlanDTO testPlan = this.tpRetrievalService.getTestSuiteTestPlan(triggerRequest, suite, itemTestPlanIds);
            response = ResponseEntity.ok((Object)testPlan);
        }
        catch (TestPlanException ex) {
            response = this.handleTestPlanException(ex, triggerRequest, TRIGGER_TEST_SUITE);
        }
        return response;
    }

    private ResponseEntity<AutomatedTestPlanDTO> handleTestPlanException(TestPlanException ex, T triggerRequest, String triggerType) throws BindException {
        if (ex instanceof InvalidParameterException) {
            return this.logInvalidParameterException((InvalidParameterException)ex, triggerRequest, triggerType);
        }
        this.logNoITPIFoundException((NoITPIFoundException)ex, triggerRequest, triggerType);
        return null;
    }

    protected void validateTriggerRequest(T triggerRequest, String objectName) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult(triggerRequest, objectName);
        this.triggerRequestValidator.validate(triggerRequest, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(triggerRequest, errors, objectName);
    }

    protected ResponseEntity<AutomatedTestPlanDTO> logInvalidParameterException(InvalidParameterException ex, T triggerRequest, String targetType) throws BindException {
        ResponseEntity response = null;
        if (ex instanceof NotFoundTargetUUIDException) {
            LOGGER.error("Trigger request rejected : this UUID was not found in the database.", (Throwable)ex);
            this.rejectTriggerRequestForNotFoundUUID(triggerRequest, targetType);
        } else {
            LOGGER.error("Return 500 response because of error while reading Execution Order JSON", (Throwable)ex);
            response = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }

    protected void logNoITPIFoundException(NoITPIFoundException ex, T triggerRequest, String targetType) throws BindException {
        LOGGER.error("Trigger request rejected : this UUID refers to " + TRIGGER_TYPE_FOR_ERROR_MESSAGES.get(targetType) + " with no automated test.", (Throwable)ex);
        this.rejectTriggerRequestForNoAutomatedTest(triggerRequest, targetType);
    }

    private void rejectTriggerRequestForNotFoundUUID(T triggerRequest, String objectName) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult(triggerRequest, objectName);
        validation.rejectValue("targetUUID", "not found", "This target UUID was not found in the database.");
        errors.add((Errors)validation);
        ErrorHandlerHelper.throwIfError(triggerRequest, errors, objectName);
    }

    private void rejectTriggerRequestForNoAutomatedTest(T triggerRequest, String objectName) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult(triggerRequest, objectName);
        validation.rejectValue("targetUUID", "empty test list", "This target UUID refers to " + TRIGGER_TYPE_FOR_ERROR_MESSAGES.get(objectName) + " with no automated test.");
        errors.add((Errors)validation);
        ErrorHandlerHelper.throwIfError(triggerRequest, errors, objectName);
    }
}

