/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.exception.artificialintelligence.server.MalformedJsonPathException;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;

@Component
public class AiServerValidator
implements Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiServerValidator.class);
    private static final String POST_AI_SERVER = "post-ai-server";
    private static final String PATCH_AI_SERVER = "patch-ai-server";
    @Inject
    private HelpValidator helpValidator;
    @Inject
    private RestAiServerService aiServerService;
    @Inject
    private JsonPathExtractor jsonPathExtractor;
    @Inject
    private AiServerManagerService aiServerManagerService;
    @Inject
    private AiServerDao aiServerDao;

    public boolean supports(Class<?> aClass) {
        return AiServerDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void aiServerPostValidator(AiServerDto aiServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiServerDto, POST_AI_SERVER);
        this.validate(aiServerDto, (Errors)validation);
        if (aiServerDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        if (!StringUtils.hasText((String)aiServerDto.getUrl())) {
            this.helpValidator.validateAttributes("url", (Errors)validation);
        }
        if (!StringUtils.hasText((String)aiServerDto.getName())) {
            this.helpValidator.validateAttributes("name", (Errors)validation);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)aiServerDto, errors, (String)POST_AI_SERVER);
    }

    public void aiServerPatchValidator(Long aiServerId, AiServerDto aiServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiServerDto, PATCH_AI_SERVER);
        this.validate(aiServerDto, (Errors)validation);
        try {
            this.aiServerService.findAiServerById(aiServerId);
        }
        catch (EntityNotFoundException e) {
            String message = String.format("No entity known for type aiServer and id %d", aiServerId);
            validation.rejectValue("id", "invalid id", message);
            LOGGER.error(message, (Object)aiServerId, (Object)e);
        }
        if (aiServerDto.getName() != null) {
            AiServer aiServer = (AiServer)this.aiServerDao.getReferenceById((Object)aiServerId);
            this.validateNameAiServer((Errors)validation, aiServerDto, aiServer);
        }
        if (aiServerDto.getJsonPath() != null) {
            this.validateJsonPathAiServer((Errors)validation, aiServerDto);
        }
        if (aiServerDto.getUrl() != null) {
            this.validateUrlAiServer((Errors)validation, aiServerDto);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)aiServerDto, errors, (String)PATCH_AI_SERVER);
    }

    private void validateJsonPathAiServer(Errors errors, AiServerDto aiServerDto) {
        if (!StringUtils.hasText((String)aiServerDto.getJsonPath())) {
            this.helpValidator.validateAttributes("jsonPath", errors);
        } else if (!this.jsonPathExtractor.isPathValid(aiServerDto.getJsonPath()) && !aiServerDto.getJsonPath().isEmpty()) {
            throw new MalformedJsonPathException();
        }
    }

    private void validateNameAiServer(Errors errors, AiServerDto aiServerDto, AiServer aiServer) {
        if (!StringUtils.hasText((String)aiServerDto.getName()) || aiServer.getName().equals(aiServerDto.getName())) {
            this.helpValidator.validateAttributes("name", errors);
        } else if (this.aiServerManagerService.nameInUse(aiServerDto.getName())) {
            errors.rejectValue("name", "generated value", "The name is already used by another server. ");
        }
    }

    private void validateUrlAiServer(Errors errors, AiServerDto aiServerDto) {
        if (!StringUtils.hasText((String)aiServerDto.getUrl())) {
            this.helpValidator.validateAttributes("url", errors);
        }
    }
}

