/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementHierarchyHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SyncedRequirementPathHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronizedFolderService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.service.internal.library.HibernatePathService;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;

@Service(value="squash.tm.plugin.xsquash4gitlab.RequirementMover")
@Transactional
public class RequirementMover {
    private final RequirementSyncExtenderDao requirementSyncExtenderDao;
    private final HibernatePathService hibernatePathService;
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final SynchronizedFolderService synchronizedFolderService;

    public RequirementMover(RequirementSyncExtenderDao requirementSyncExtenderDao, HibernatePathService hibernatePathService, RequirementLibraryNavigationService requirementLibraryNavigationService, SynchronizedFolderService synchronizedFolderService) {
        this.requirementSyncExtenderDao = requirementSyncExtenderDao;
        this.hibernatePathService = hibernatePathService;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.synchronizedFolderService = synchronizedFolderService;
    }

    public void moveMisplacedRequirements(GitLabRemoteSynchronisation synchronisation, Map<String, Optional<GitLabIssue>> unprocessedGitLabIssues) {
        unprocessedGitLabIssues.forEach((key, gitLabIssue) -> this.moveUnprocessedRequirementIfNecessary((String)key, synchronisation, (Optional<GitLabIssue>)gitLabIssue));
    }

    private void moveUnprocessedRequirementIfNecessary(String remoteKey, GitLabRemoteSynchronisation synchronisation, Optional<GitLabIssue> issue) {
        Long syncId = synchronisation.getRemoteSynchronisation().getId();
        RequirementSyncExtender extender = this.requirementSyncExtenderDao.retrieveByRemoteKeyAndSyncId(remoteKey, syncId);
        Long rootFolderId = this.synchronizedFolderService.getRootTargetFolderId(synchronisation.getRemoteSynchronisation());
        String rootFolderPath = this.getFolderPath(rootFolderId);
        Long requirementId = extender.getRequirement().getId();
        if (issue.isPresent()) {
            boolean hasRemoteModification = RemoteRequirementFinder.hasRemoteModifications(issue.get(), extender);
            String currentPath = this.hibernatePathService.buildRequirementPath(requirementId.longValue());
            boolean shouldMove = RequirementHierarchyHelper.shouldMoveSyncedRequirement(synchronisation, rootFolderPath, currentPath, false, issue.get(), hasRemoteModification);
            if (shouldMove) {
                this.updateRequirementPath(issue.get(), synchronisation, extender, rootFolderPath);
            }
        }
    }

    private void moveRequirementToFolder(Long rootFolderId, Long requirementId) {
        Long[] reqIds = (Long[])Collections.singletonList(requirementId).toArray(Long[]::new);
        this.requirementLibraryNavigationService.moveNodesToFolder(rootFolderId.longValue(), reqIds);
    }

    public void updateRequirementPath(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RequirementSyncExtender extender, String rootFolderPath) {
        Long requirementId = extender.getRequirement().getId();
        String newParentFolderPath = SyncedRequirementPathHelper.buildGroupFolderPath(gitLabRemoteSynchronisation, gitLabIssue, rootFolderPath);
        Long destinationFolderId = this.synchronizedFolderService.createFolderOrGetId(newParentFolderPath);
        this.moveRequirementToFolder(destinationFolderId, requirementId);
    }

    public String buildRequirementPath(GitLabRemoteSynchronisation synchronisation, GitLabIssue gitLabIssue, String rootFolderPath) {
        String targetVersionName = gitLabIssue.getTitle();
        String escapedVersionName = targetVersionName.replace("/", "\\/");
        return SyncedRequirementPathHelper.buildRequirementPath(synchronisation, gitLabIssue, escapedVersionName, rootFolderPath);
    }

    public String getFolderPath(Long folderId) {
        return this.fixGetPathAsString(this.requirementLibraryNavigationService.getPathAsString(folderId.longValue()));
    }

    private String fixGetPathAsString(String pathAsString) {
        while (pathAsString.contains("//")) {
            pathAsString = pathAsString.replaceAll("//", "/");
        }
        return pathAsString;
    }
}

