/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.repository;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PersistedConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.Xsquash4GitLabConfigurationException;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@Service
@Transactional
@Component(value="xsquash4gitlabConfigurationDao")
public class ConfigurationDao {
    private final GenericProjectManagerService projectManager;

    public ConfigurationDao(GenericProjectManagerService projectManager) {
        this.projectManager = projectManager;
    }

    public PersistedConfiguration loadOrGetDefaultConfiguration(Long projectId) throws IOException {
        Map<String, String> rawConfiguration = this.getRawConfiguration(projectId);
        if (rawConfiguration == null || rawConfiguration.isEmpty()) {
            return PersistedConfiguration.withDefaultConfiguration();
        }
        return PersistedConfiguration.fromRawMap(rawConfiguration);
    }

    public void saveConfiguration(Long projectId, long syncId, Mappings mappings, boolean displayState) throws IOException {
        PersistedConfiguration configuration = this.loadOrGetDefaultConfiguration(projectId);
        Map<Long, Mappings> mappingsBySyncIds = configuration.getMappingsBySyncIds();
        mappingsBySyncIds.put(syncId, Mappings.getCleanedMappings(mappings));
        Map<Long, Boolean> displayStateBySyncId = configuration.getDisplayStateBySyncId();
        displayStateBySyncId.put(syncId, displayState);
        this.doSaveConfiguration(projectId, new PersistedConfiguration(mappingsBySyncIds, displayStateBySyncId));
    }

    private void doSaveConfiguration(Long projectId, PersistedConfiguration persistedConfiguration) throws IOException {
        this.projectManager.setPluginConfiguration(projectId.longValue(), ConfigurationService.CONFIGURING_WORKSPACE, "squash.tm.plugin.xsquash4gitlab", persistedConfiguration.asRawMap());
    }

    private Map<String, String> getRawConfiguration(Long projectId) {
        return this.projectManager.getPluginConfigurationWithoutCheck(projectId.longValue(), ConfigurationService.CONFIGURING_WORKSPACE, "squash.tm.plugin.xsquash4gitlab");
    }

    public void updateDisplayState(long projectId, long syncId, boolean newValue) {
        try {
            PersistedConfiguration configuration = this.loadOrGetDefaultConfiguration(projectId);
            configuration.setDisplayStateBySyncId(Map.of(syncId, newValue));
            this.projectManager.setPluginConfiguration(projectId, ConfigurationService.CONFIGURING_WORKSPACE, "squash.tm.plugin.xsquash4gitlab", configuration.asRawMap());
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException("Unable to fetch the configuration from project " + projectId, (Throwable)ex);
        }
    }

    public void removeSyncPropertyBindings(long projectId, List<Long> syncIds) {
        try {
            PersistedConfiguration configuration = this.loadOrGetDefaultConfiguration(projectId);
            Map<Long, Mappings> mappingsBySyncIds = configuration.getMappingsBySyncIds();
            syncIds.forEach(mappingsBySyncIds::remove);
            Map<Long, Boolean> displayStateBySyncId = configuration.getDisplayStateBySyncId();
            syncIds.forEach(displayStateBySyncId::remove);
            this.doSaveConfiguration(projectId, new PersistedConfiguration(mappingsBySyncIds, displayStateBySyncId));
        }
        catch (IOException e) {
            throw new Xsquash4GitLabConfigurationException("Could not delete sprint synchronisation.", e);
        }
    }
}

