/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Optional;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.BoardAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabConverters;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabBoardScope;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupBoardScopeQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectBoardScopeQuery;

public class GitLabBoardScopeConverter {
    public static GitLabBoardScope convertProjectBoardScope(@Nullable GetProjectBoardScopeQuery.Data data) {
        return Optional.ofNullable(data).map(GetProjectBoardScopeQuery.Data::project).map(GetProjectBoardScopeQuery.Project::board).map(board -> {
            BoardAdapter.ProjectBoard boardAdapter = new BoardAdapter.ProjectBoard((GetProjectBoardScopeQuery.Board)board);
            return GitLabBoardScopeConverter.convertGitLabBoardFilters(boardAdapter);
        }).orElseThrow(() -> GitLabConverters.exception("Received malformed project board filters"));
    }

    public static GitLabBoardScope convertGroupBoardScope(@Nullable GetGroupBoardScopeQuery.Data data) {
        return Optional.ofNullable(data).map(GetGroupBoardScopeQuery.Data::group).map(GetGroupBoardScopeQuery.Group::board).map(board -> {
            BoardAdapter.GroupBoard boardAdapter = new BoardAdapter.GroupBoard((GetGroupBoardScopeQuery.Board)board);
            return GitLabBoardScopeConverter.convertGitLabBoardFilters(boardAdapter);
        }).orElseThrow(() -> GitLabConverters.exception("Received malformed group board filters"));
    }

    private static GitLabBoardScope convertGitLabBoardFilters(BoardAdapter boardAdapter) {
        return new GitLabBoardScope(GitLabBoardScopeConverter.extractMilestone(boardAdapter), GitLabBoardScopeConverter.extractIteration(boardAdapter), boardAdapter.getLabels(), GitLabBoardScopeConverter.extractAssignee(boardAdapter), boardAdapter.weight());
    }

    private static GitLabNamedReferenceDto extractMilestone(BoardAdapter board) {
        return GitLabConverters.extractNamedReference(board, BoardAdapter::milestoneId, BoardAdapter::milestoneTitle);
    }

    private static GitLabNamedReferenceDto extractIteration(BoardAdapter board) {
        return GitLabConverters.extractNamedReference(board, BoardAdapter::iterationId, BoardAdapter::iterationTitle);
    }

    private static GitLabNamedReferenceDto extractAssignee(BoardAdapter board) {
        return GitLabConverters.extractNamedReference(board, BoardAdapter::assigneeUsername, BoardAdapter::assigneeName);
    }

    private GitLabBoardScopeConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }
}

