/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller.dto;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.IterationState;

public class IterationDto {
    private final String id;
    private final String title;
    private final Date startDate;
    private final Date dueDate;
    private final String iterationGroup;
    private final IterationState state;

    public IterationDto(String id, String title, Date startDate, Date dueDate, String iterationGroup, IterationState state) {
        this.id = id;
        this.title = title;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.iterationGroup = iterationGroup;
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getIterationGroup() {
        return this.iterationGroup;
    }

    public String getIterationFolderPath() {
        StringBuilder str = new StringBuilder();
        str.append(this.iterationGroup.trim());
        str.append("/");
        str.append(this.formatDateForPath(this.startDate));
        str.append(" - ");
        str.append(this.formatDateForPath(this.dueDate));
        return str.toString();
    }

    public IterationState getState() {
        return this.state;
    }

    public String generateIterationName() {
        StringBuilder str = new StringBuilder();
        str.append(this.formatDate(this.startDate));
        str.append(" - ");
        str.append(this.formatDate(this.dueDate));
        return str.toString();
    }

    private String formatDateForPath(Date date) {
        String formattedDate = this.formatDate(date);
        return formattedDate.replaceAll("/", "\\\\/");
    }

    private String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }
}

