/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.BugzillaBugTrackerInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.BugzillaEntityMapping;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.BugzillaWidgetMapping;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.SquashIssueFiller;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Bug;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaFieldInfo;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaFieldSchema;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaStandardOperation;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Product;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.User;

@Component
public class BugzillaToSquashEntityConverter {
    private static final String ISSUETYPE_FIELD_ID = "component";
    private static final String PROJECTS_FIELD_ID = "product";
    @Inject
    private BugzillaWidgetMapping bugzillaWidgetMapping;
    @Inject
    private BugzillaEntityMapping bugzillaEntityMapping;

    public AdvancedIssue convertToSquashIssue(Bug issue) {
        AdvancedIssue squashIssue = new AdvancedIssue();
        SquashIssueFiller.fillSquashIssue(squashIssue, issue, ISSUETYPE_FIELD_ID);
        return squashIssue;
    }

    public List<AdvancedIssue> convertToSquashIssues(Iterable<Bug> issueList) {
        ArrayList<AdvancedIssue> issues = new ArrayList<AdvancedIssue>();
        for (Bug bug : issueList) {
            AdvancedIssue squashIssue = new AdvancedIssue();
            SquashIssueFiller.fillSquashIssue(squashIssue, bug, ISSUETYPE_FIELD_ID);
            issues.add(squashIssue);
        }
        return issues;
    }

    public AdvancedProject createReadOnlyProjectStub(String schemeName, BugzillaBugTrackerInterfaceDescriptor descriptor) {
        AdvancedProject project = new AdvancedProject();
        Field summaryField = this.createReadOnlyField("summary", descriptor.getReportSummaryLabel());
        Field descriptionField = this.createReadOnlyField("description", descriptor.getReportDescriptionLabel());
        descriptionField.getRendering().getInputType().setName(InputType.TypeName.TEXT_AREA.value);
        Field statusField = this.createReadOnlyField("status", descriptor.getTableStatusHeader());
        Field assigneeField = this.createReadOnlyField("assignee", descriptor.getReportAssigneeLabel());
        Field priorityField = this.createReadOnlyField("priority", descriptor.getReportPriorityLabel());
        project.setSchemeMap(Collections.singletonMap(schemeName, Arrays.asList(summaryField, priorityField, statusField, assigneeField, descriptionField)));
        return project;
    }

    private Field createReadOnlyField(String id, String label) {
        Field field = new Field(id, label);
        Rendering rendering = new Rendering(new String[0], new InputType(InputType.TypeName.TEXT_FIELD.value, "unknown"), false);
        field.setRendering(rendering);
        return field;
    }

    public AdvancedProject convertToSquashProject(Product product) {
        AdvancedProject squashProject = new AdvancedProject();
        this.bugzillaWidgetMapping.getProjectKeyHolder().set(String.valueOf(product.getId()));
        squashProject.setId(String.valueOf(product.getId()));
        squashProject.setName(product.getName());
        List<org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Component> issueTypes = product.getComponents();
        squashProject.setSchemeMap(this.buildSchemeMap(issueTypes));
        return squashProject;
    }

    private Map<String, List<Field>> buildSchemeMap(List<org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Component> issueTypes) {
        HashMap<String, List<Field>> schemes = new HashMap<String, List<Field>>();
        Field issueTypeField = this.createEmptyIssueTypeField();
        ArrayList<FieldValue> possibleIssueTypes = new ArrayList<FieldValue>();
        for (org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Component issueType : issueTypes) {
            this.buildSchemeForIssueType(issueType, schemes, issueTypeField, possibleIssueTypes);
        }
        issueTypeField.setPossibleValues(possibleIssueTypes.toArray(new FieldValue[possibleIssueTypes.size()]));
        return schemes;
    }

    private void buildSchemeForIssueType(org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Component issueType, Map<String, List<Field>> schemes, Field issueTypeField, List<FieldValue> possibleIssueTypes) {
        Map<String, BugzillaFieldInfo> fields = issueType.getFields();
        String schemeKey = "component:" + issueType.getName();
        ArrayList<Field> schemeFields = new ArrayList<Field>();
        schemes.put(schemeKey, schemeFields);
        schemeFields.add(issueTypeField);
        for (Map.Entry<String, BugzillaFieldInfo> entry : fields.entrySet()) {
            BugzillaFieldInfo fieldInfo = entry.getValue();
            String key = entry.getKey();
            if (key.equals(PROJECTS_FIELD_ID)) continue;
            if (key.equals(ISSUETYPE_FIELD_ID)) {
                issueTypeField.setLabel(fieldInfo.getName());
                FieldValue newIssueType = new FieldValue(String.valueOf(issueType.getId()), issueType.getName());
                newIssueType.setTypename(ISSUETYPE_FIELD_ID);
                possibleIssueTypes.add(newIssueType);
                continue;
            }
            Field squashField = this.bugzillaField2SquashField(fieldInfo);
            if (squashField == null) continue;
            schemeFields.add(squashField);
        }
    }

    private Field bugzillaField2SquashField(BugzillaFieldInfo fieldInfo) {
        Field field = new Field();
        field.setId(fieldInfo.getId());
        String fieldName = fieldInfo.getName();
        field.setLabel(fieldName);
        List<FieldValue> possibleValues = this.bugzillaEntityMapping.createFieldValues(fieldInfo);
        field.setPossibleValues(possibleValues.toArray(new FieldValue[possibleValues.size()]));
        field.setRendering(this.bugzilla2SquashRendering(fieldInfo));
        return field;
    }

    private Rendering bugzilla2SquashRendering(BugzillaFieldInfo fieldInfo) {
        Rendering rendering = new Rendering();
        ArrayList<String> operations = new ArrayList<String>();
        if (fieldInfo.getOperations() != null) {
            for (BugzillaStandardOperation operation : fieldInfo.getOperations()) {
                operations.add(operation.name());
            }
        }
        rendering.setOperations(operations.toArray(new String[operations.size()]));
        rendering.setInputType(this.bugzilla2SquashInputType(fieldInfo.getSchema()));
        rendering.setRequired(fieldInfo.isRequired());
        return rendering;
    }

    private InputType bugzilla2SquashInputType(BugzillaFieldSchema schema) {
        InputType inputType = new InputType();
        String originalName = schema.isCustom() ? schema.getCustom() : schema.getSystem();
        inputType.setOriginal(originalName);
        String squashName = this.bugzillaWidgetMapping.getCorrespondingSquashWidget(originalName);
        inputType.setName(squashName);
        Map<String, String> params = this.bugzillaWidgetMapping.getAdditionalParams(inputType);
        inputType.setConfiguration(params);
        Object type = schema.getType();
        if ("array".equals(type)) {
            type = schema.getItems() + "-" + schema.getType();
        }
        if ("string-array".equals(type)) {
            type = squashName;
        }
        inputType.setDataType((String)type);
        return inputType;
    }

    private Field createEmptyIssueTypeField() {
        Field issueTypeField = new Field();
        issueTypeField.setId(ISSUETYPE_FIELD_ID);
        InputType inputType = new InputType(InputType.TypeName.DROPDOWN_LIST.value, ISSUETYPE_FIELD_ID);
        inputType.setFieldSchemeSelector(true);
        Rendering rendering = new Rendering(new String[]{"SET"}, inputType, true);
        issueTypeField.setRendering(rendering);
        return issueTypeField;
    }

    public FieldValue convertToUserCompositeFieldValue(Iterable<User> users) {
        FieldValue newValue = new FieldValue();
        ArrayList<FieldValue> resultUsers = new ArrayList<FieldValue>();
        for (User user : users) {
            FieldValue uValue = new FieldValue(user.getName(), user.getName());
            uValue.setTypename("user");
            resultUsers.add(uValue);
        }
        newValue.setComposite(resultUsers.toArray(new FieldValue[resultUsers.size()]));
        return newValue;
    }
}

