/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.client;

import bugzilla.org.apache.xmlrpc.XmlRpcException;
import bugzilla.org.apache.xmlrpc.XmlRpcRequest;
import bugzilla.org.apache.xmlrpc.client.XmlRpcClient;
import bugzilla.org.apache.xmlrpc.client.XmlRpcClientException;
import bugzilla.org.apache.xmlrpc.client.XmlRpcStreamTransport;
import bugzilla.org.apache.xmlrpc.common.LocalStreamConnection;
import bugzilla.org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import bugzilla.org.apache.xmlrpc.common.XmlRpcStreamRequestProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class XmlRpcLocalStreamTransport
extends XmlRpcStreamTransport {
    private final XmlRpcStreamRequestProcessor localServer;
    private LocalStreamConnection conn;
    private XmlRpcRequest request;

    public XmlRpcLocalStreamTransport(XmlRpcClient pClient, XmlRpcStreamRequestProcessor pServer) {
        super(pClient);
        this.localServer = pServer;
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        return pConfig.isGzipRequesting();
    }

    protected void close() throws XmlRpcClientException {
    }

    protected InputStream getInputStream() throws XmlRpcException {
        this.localServer.execute(this.conn.getConfig(), this.conn.getServerStreamConnection());
        return new ByteArrayInputStream(this.conn.getResponse().toByteArray());
    }

    protected XmlRpcStreamTransport.ReqWriter newReqWriter(XmlRpcRequest pRequest) throws XmlRpcException, IOException, SAXException {
        this.request = pRequest;
        return super.newReqWriter(pRequest);
    }

    protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException, IOException, SAXException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pWriter.write(baos);
        XmlRpcStreamRequestConfig config = (XmlRpcStreamRequestConfig)this.request.getConfig();
        this.conn = new LocalStreamConnection(config, new ByteArrayInputStream(baos.toByteArray()));
    }
}

