/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import jirarest.org.apache.http.HttpHost;
import jirarest.org.apache.http.HttpRequest;
import jirarest.org.apache.http.HttpResponse;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.client.HttpClient;
import jirarest.org.apache.http.client.ResponseHandler;
import jirarest.org.apache.http.client.ServiceUnavailableRetryStrategy;
import jirarest.org.apache.http.client.methods.HttpUriRequest;
import jirarest.org.apache.http.conn.ClientConnectionManager;
import jirarest.org.apache.http.impl.client.DefaultHttpClient;
import jirarest.org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import jirarest.org.apache.http.params.HttpParams;
import jirarest.org.apache.http.protocol.HttpContext;
import jirarest.org.apache.http.util.Args;
import jirarest.org.apache.http.util.EntityUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class AutoRetryHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final ServiceUnavailableRetryStrategy retryStrategy;
    private final Log log = LogFactory.getLog(this.getClass());

    public AutoRetryHttpClient(HttpClient client, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(client, "HttpClient");
        Args.notNull(retryStrategy, "ServiceUnavailableRetryStrategy");
        this.backend = client;
        this.retryStrategy = retryStrategy;
    }

    public AutoRetryHttpClient() {
        this(new DefaultHttpClient(), new DefaultServiceUnavailableRetryStrategy());
    }

    public AutoRetryHttpClient(ServiceUnavailableRetryStrategy config) {
        this(new DefaultHttpClient(), config);
    }

    public AutoRetryHttpClient(HttpClient client) {
        this(client, new DefaultServiceUnavailableRetryStrategy());
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        HttpContext defaultContext = null;
        return this.execute(target, request, defaultContext);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(target, request, context);
        return responseHandler.handleResponse(resp);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request) throws IOException {
        HttpContext context = null;
        return this.execute(request, context);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        URI uri = request.getURI();
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        return this.execute(httpHost, (HttpRequest)request, context);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(request, context);
        return responseHandler.handleResponse(resp);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        int c = 1;
        while (true) {
            block8: {
                HttpResponse response = this.backend.execute(target, request, context);
                try {
                    if (this.retryStrategy.retryRequest(response, c, context)) {
                        EntityUtils.consume(response.getEntity());
                        long nextInterval = this.retryStrategy.getRetryInterval();
                        try {
                            this.log.trace((Object)("Wait for " + nextInterval));
                            Thread.sleep(nextInterval);
                            break block8;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return response;
                }
                catch (RuntimeException ex) {
                    try {
                        EntityUtils.consume(response.getEntity());
                    }
                    catch (IOException ioex) {
                        this.log.warn((Object)"I/O error consuming response content", (Throwable)ioex);
                    }
                    throw ex;
                }
            }
            ++c;
        }
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }
}

