/*
 * Decompiled with CFR 0.152.
 */
package jirarest.io.atlassian.util.concurrent;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jirarest.io.atlassian.util.concurrent.Expiring;
import jirarest.io.atlassian.util.concurrent.LazyReference;
import jirarest.io.atlassian.util.concurrent.ResettableLazyReference;
import jirarest.io.atlassian.util.concurrent.Timeout;

public final class Lazy {
    public static <T> Supplier<T> supplier(Supplier<T> factory) {
        return new Strong<T>(factory);
    }

    public static <T> Supplier<T> callable(Callable<T> factory) {
        return new Strong<T>(factory);
    }

    public static <T> Supplier<T> timeToLive(Supplier<T> factory, long time, TimeUnit unit) {
        return new Expiring<T>(factory, () -> new TimeToLive(Timeout.getNanosTimeout(time, unit)));
    }

    public static <T> Supplier<T> timeToIdle(Supplier<T> factory, long time, TimeUnit unit) {
        return new Expiring<T>(factory, () -> new TimeToIdle(Timeout.timeoutFactory(time, unit, Timeout.TimeSuppliers.NANOS)));
    }

    public static <T> ResettableLazyReference<T> resettable(Supplier<T> factory) {
        return Lazy.resettableCallable(factory::get);
    }

    public static <T> ResettableLazyReference<T> resettableCallable(final Callable<T> factory) {
        return new ResettableLazyReference<T>(){

            @Override
            protected T create() throws Exception {
                return factory.call();
            }
        };
    }

    static final class TimeToIdle
    implements Predicate<Void> {
        private volatile Timeout lastAccess;
        private final Supplier<Timeout> timeout;

        TimeToIdle(Supplier<Timeout> timeout) {
            this.timeout = Objects.requireNonNull(timeout);
            this.lastAccess = timeout.get();
        }

        @Override
        public boolean test(Void input) {
            boolean alive;
            boolean bl = alive = !this.lastAccess.isExpired();
            if (alive) {
                this.lastAccess = this.timeout.get();
            }
            return alive;
        }
    }

    static final class TimeToLive
    implements Predicate<Void> {
        private final Timeout timeout;

        TimeToLive(Timeout timeout) {
            this.timeout = timeout;
        }

        @Override
        public boolean test(Void input) {
            return !this.timeout.isExpired();
        }
    }

    static final class Strong<T>
    extends LazyReference<T> {
        volatile Callable<T> callable;

        Strong(Supplier<T> supplier) {
            this.callable = Objects.requireNonNull(supplier::get);
        }

        Strong(Callable<T> callable) {
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        protected T create() throws Exception {
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                this.callable = null;
            }
        }
    }
}

