/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jirarest.com.atlassian.httpclient.api.HttpClient;
import jirarest.com.atlassian.jira.rest.client.api.ComponentRestClient;
import jirarest.com.atlassian.jira.rest.client.api.domain.Component;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.ComponentInput;
import jirarest.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirarest.com.atlassian.jira.rest.client.internal.domain.input.ComponentInputWithProjectKey;
import jirarest.com.atlassian.jira.rest.client.internal.json.ComponentJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.gen.ComponentInputWithProjectKeyJsonGenerator;
import jirarest.com.sun.ws.rs.core.UriBuilder;
import jirarest.io.atlassian.util.concurrent.Promise;
import jirarest.javax.annotation.Nullable;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public class AsynchronousComponentRestClient
extends AbstractAsynchronousRestClient
implements ComponentRestClient {
    private final ComponentJsonParser componentJsonParser = new ComponentJsonParser();
    private final URI componentUri;

    public AsynchronousComponentRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.componentUri = UriBuilder.fromUri(baseUri).path("component").build(new Object[0]);
    }

    @Override
    public Promise<Component> getComponent(URI componentUri) {
        return this.getAndParse(componentUri, this.componentJsonParser);
    }

    @Override
    public Promise<Component> createComponent(String projectKey, ComponentInput componentInput) {
        ComponentInputWithProjectKey helper = new ComponentInputWithProjectKey(projectKey, componentInput);
        return this.postAndParse(this.componentUri, helper, new ComponentInputWithProjectKeyJsonGenerator(), this.componentJsonParser);
    }

    @Override
    public Promise<Component> updateComponent(URI componentUri, ComponentInput componentInput) {
        ComponentInputWithProjectKey helper = new ComponentInputWithProjectKey(null, componentInput);
        return this.putAndParse(componentUri, helper, new ComponentInputWithProjectKeyJsonGenerator(), this.componentJsonParser);
    }

    @Override
    public Promise<Void> removeComponent(URI componentUri, @Nullable URI moveIssueToComponentUri) {
        UriBuilder uriBuilder = UriBuilder.fromUri(componentUri);
        if (moveIssueToComponentUri != null) {
            uriBuilder.queryParam("moveIssuesTo", moveIssueToComponentUri);
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    @Override
    public Promise<Integer> getComponentRelatedIssuesCount(URI componentUri) {
        URI relatedIssueCountsUri = UriBuilder.fromUri(componentUri).path("relatedIssueCounts").build(new Object[0]);
        return this.getAndParse(relatedIssueCountsUri, new JsonObjectParser<Integer>(){

            @Override
            public Integer parse(JSONObject json) throws JSONException {
                return json.getInt("issueCount");
            }
        });
    }
}

