/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.api.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Map;
import jirarest.com.atlassian.jira.rest.client.api.domain.Permission;
import jirarest.javax.annotation.Nullable;

public class Permissions {
    public static final String WORK_ISSUE = "WORK_ISSUE";
    private final Map<String, Permission> permissionMap;

    public Permissions(Iterable<Permission> permissions) {
        this.permissionMap = Maps.uniqueIndex(permissions, Permission.TO_KEY);
    }

    public Map<String, Permission> getPermissionMap() {
        return this.permissionMap;
    }

    public boolean havePermission(String permissionKey) {
        Permission permission = this.getPermission(permissionKey);
        return permission != null && permission.havePermission();
    }

    @Nullable
    public Permission getPermission(String permissionKey) {
        return this.permissionMap.get(permissionKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("permissionMap", this.permissionMap).toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Permissions) {
            Permissions that = (Permissions)o;
            return Objects.equal(this.permissionMap, that.permissionMap);
        }
        return false;
    }

    public int hashCode() {
        return this.permissionMap.hashCode();
    }
}

