/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations;

import java.net.URI;
import java.util.Optional;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import jiracloud.org.codehaus.jettison.json.JSONArray;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.exceptions.JiraProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtensionClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.JiraRestClientOperation;

public class GetProjectKeyByName
extends JiraRestClientOperation<String> {
    private static final String PROJECT_SEARCH_PATH = "project/search";
    private static final String QUERY_QUERY = "query";
    private static final String QUERY_START_AT = "startAt";
    private static final String QUERY_MAX_RESULTS = "maxResults";
    private static final String QUERY_FIELDS = "fields";
    private static final String FIELD_NAME = "name";
    private static final int MAX_RESULTS = 50;
    private static final String JSON_TOTAL = "total";
    private static final String JSON_MAX_RESULTS = "maxResults";
    private static final String JSON_VALUES = "values";
    private static final String JSON_PROJECT_NAME = "name";
    private static final String JSON_PROJECT_KEY = "key";
    private final String projectName;

    public GetProjectKeyByName(ExtendedJiraRestClient client, String projectName) {
        super(client);
        this.projectName = projectName;
    }

    @Override
    public String doIt() {
        ProjectPageResult page;
        ExtensionClient extension = this.client.getExtensionClient();
        URI baseUri = extension.getBaseURI();
        int startAt = 0;
        do {
            Optional<String> key;
            if (!(key = (page = this.fetchPage(extension, baseUri, startAt)).key()).isPresent()) continue;
            return key.get();
        } while ((startAt += page.maxResults()) < page.total());
        throw new JiraProjectNotFound(this.projectName);
    }

    private ProjectPageResult fetchPage(ExtensionClient extension, URI baseUri, int startAt) {
        try {
            URI uri = UriBuilder.fromUri(baseUri).path(PROJECT_SEARCH_PATH).queryParam(QUERY_QUERY, this.projectName).queryParam(QUERY_START_AT, startAt).queryParam("maxResults", 50).queryParam(QUERY_FIELDS, "name").build(new Object[0]);
            return extension.getAndParse(uri, new ProjectPageParser(this.projectName)).claim();
        }
        catch (Exception exception) {
            throw new JiraProjectNotFound("Failed to retrieve Jira project.");
        }
    }

    private record ProjectPageParser(String projectName) implements JsonObjectParser<ProjectPageResult>
    {
        @Override
        public ProjectPageResult parse(JSONObject json) {
            try {
                int total = json.getInt(GetProjectKeyByName.JSON_TOTAL);
                int maxResults = json.getInt("maxResults");
                JSONArray projects = json.getJSONArray(GetProjectKeyByName.JSON_VALUES);
                Optional<String> key = this.findProjectKey(projects);
                return new ProjectPageResult(key, total, maxResults);
            }
            catch (Exception exception) {
                throw new JiraProjectNotFound("Failed to parse Jira project search response.");
            }
        }

        private Optional<String> findProjectKey(JSONArray projects) throws JSONException {
            int i = 0;
            while (i < projects.length()) {
                JSONObject project = projects.getJSONObject(i);
                if (this.projectName.equals(project.getString("name"))) {
                    return Optional.of(project.getString(GetProjectKeyByName.JSON_PROJECT_KEY));
                }
                ++i;
            }
            return Optional.empty();
        }
    }

    private record ProjectPageResult(Optional<String> key, int total, int maxResults) {
    }
}

