/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.exception.WrongProjectPathFormatException;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Team;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Project {
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String url;
    @JsonProperty
    private String state;
    @JsonProperty
    private Long revision;
    @JsonProperty
    private String visibility;
    @JsonProperty
    private Date lastUpdateTime;
    @JsonProperty(value="defaultTeam")
    private Team azureDevOpsDefaultTeam;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Team getDefaultTeam() {
        return this.azureDevOpsDefaultTeam;
    }

    public void setDefaultTeam(Team team) {
        this.azureDevOpsDefaultTeam = team;
    }

    public String toString() {
        return "AzureDevOpsProject{id='" + this.id + "', name='" + this.name + "', url='" + this.url + "', state='" + this.state + "', revision=" + this.revision + ", visibility='" + this.visibility + "', lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + "}";
    }

    public static String extractOrganizationName(String projectPath) {
        if (projectPath.indexOf("/") > 0) {
            return projectPath.split("/")[0];
        }
        throw new WrongProjectPathFormatException(projectPath);
    }

    public static String extractProjectName(String projectPath) {
        if (projectPath.indexOf("/") > 0 && projectPath.split("/").length > 1) {
            return projectPath.split("/")[1];
        }
        throw new WrongProjectPathFormatException(projectPath);
    }
}

