/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.service;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.Issue;
import gitlabbt.org.gitlab4j.api.models.LinkType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.plugin.bugtracker.gitlab.dao.GitLabIssueKeyDao;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabIssueKey;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;

@Service
public class GitLabIssueLinkService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabIssueLinkService.class);
    private final GitLabIssueKeyDao gitLabIssueKeyDao;

    public GitLabIssueLinkService(GitLabIssueKeyDao gitLabIssueKeyDao) {
        this.gitLabIssueKeyDao = gitLabIssueKeyDao;
    }

    public void linkIssues(GitLabApiWrapper gitLabApiWrapper, String remoteIssueKey, List<RemoteRequirementAndProjectId> remoteRequirementAndProjectIds) {
        GitLabIssueKey sourceGitLabIssueKey = this.gitLabIssueKeyDao.fetchGitLabIssueKey(remoteIssueKey);
        if (sourceGitLabIssueKey == null) {
            throw new BugTrackerLocalException("Cannot find issue with ID %s to attach to.".formatted(remoteIssueKey), null);
        }
        String sourceProjectPath = sourceGitLabIssueKey.getProjectPath();
        Long sourceIssueIid = sourceGitLabIssueKey.getIid();
        HashMap<String, List<Issue>> issuesByProjectId = new HashMap<String, List<Issue>>();
        for (RemoteRequirementAndProjectId remoteRequirementAndProjectId : remoteRequirementAndProjectIds) {
            GitLabIssueLinkService.processSingleIssueLink(gitLabApiWrapper, remoteRequirementAndProjectId, issuesByProjectId, sourceProjectPath, sourceIssueIid);
        }
    }

    private static void processSingleIssueLink(GitLabApiWrapper gitLabApiWrapper, RemoteRequirementAndProjectId remoteRequirementAndProjectId, Map<String, List<Issue>> issuesByProjectId, String sourceProjectPath, Long sourceIssueIid) {
        try {
            List allProjectIssues = issuesByProjectId.computeIfAbsent(remoteRequirementAndProjectId.remoteProjectId(), remoteProjectId -> GitLabIssueLinkService.getIssues(gitLabApiWrapper, remoteProjectId));
            Long targetIssueId = Long.parseLong(remoteRequirementAndProjectId.remoteReqId());
            Issue targetIssue = allProjectIssues.stream().filter(issue -> issue.getId().equals(targetIssueId)).findFirst().orElse(null);
            if (targetIssue == null) {
                LOGGER.warn("Issue with ID {} not found.", new Object[]{targetIssueId});
                return;
            }
            gitLabApiWrapper.createIssueLink(sourceProjectPath, sourceIssueIid, remoteRequirementAndProjectId.remoteProjectId(), targetIssue.getIid(), LinkType.RELATES_TO);
        }
        catch (GitLabApiException e) {
            LOGGER.warn("Error while fetching issue with ID {}.", new Object[]{remoteRequirementAndProjectId.remoteReqId(), e});
        }
    }

    private static List<Issue> getIssues(GitLabApiWrapper gitLabApiWrapper, String remoteProjectId) {
        try {
            return gitLabApiWrapper.getAllProjectIssues(remoteProjectId);
        }
        catch (GitLabApiException e) {
            throw new BugTrackerLocalException((Throwable)e);
        }
    }
}

