/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api.models;

import gitlabbt.com.fasterxml.jackson.annotation.JsonCreator;
import gitlabbt.com.fasterxml.jackson.annotation.JsonIgnore;
import gitlabbt.com.fasterxml.jackson.annotation.JsonValue;
import gitlabbt.org.gitlab4j.models.GitLabForm;
import gitlabbt.org.gitlab4j.models.utils.ISO8601;
import gitlabbt.org.gitlab4j.models.utils.JacksonJsonEnumHelper;
import java.io.Serializable;
import java.util.Date;

public class IterationFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IterationFilterState state;
    private String search;
    private IterationFilterIn in;
    private Boolean includeAncestors;
    private Date updatedAfter;
    private Date updatedBefore;

    public IterationFilterState getState() {
        return this.state;
    }

    public void setState(IterationFilterState state) {
        this.state = state;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public IterationFilterIn getIn() {
        return this.in;
    }

    public void setIn(IterationFilterIn in) {
        this.in = in;
    }

    public Boolean getIncludeAncestors() {
        return this.includeAncestors;
    }

    public void setIncludeAncestors(Boolean includeAncestors) {
        this.includeAncestors = includeAncestors;
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public IterationFilter withState(IterationFilterState state) {
        this.state = state;
        return this;
    }

    public IterationFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public IterationFilter withIn(IterationFilterIn in) {
        this.in = in;
        return this;
    }

    public IterationFilter withIncludeAncestors(Boolean includeAncestors) {
        this.includeAncestors = includeAncestors;
        return this;
    }

    public IterationFilter withUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    public IterationFilter withUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    @JsonIgnore
    public GitLabForm getQueryParams(int page, int perPage) {
        return this.getQueryParams().withParam("page", page).withParam("per_page", perPage);
    }

    @JsonIgnore
    public GitLabForm getQueryParams() {
        return new GitLabForm().withParam("state", (Object)this.state).withParam("search", this.search).withParam("in", (Object)this.in).withParam("include_ancestors", this.includeAncestors).withParam("updated_after", ISO8601.toString(this.updatedAfter, false)).withParam("updated_before", ISO8601.toString(this.updatedBefore, false));
    }

    public static enum IterationFilterIn {
        TITLE,
        CADENCE_TITLE;

        private static JacksonJsonEnumHelper<IterationFilterIn> enumHelper;

        @JsonCreator
        public static IterationFilterIn forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IterationFilterIn>(IterationFilterIn.class, false, false, true);
        }
    }

    public static enum IterationFilterState {
        OPENED,
        UPCOMING,
        CURRENT,
        CLOSED,
        ALL;

        private static JacksonJsonEnumHelper<IterationFilterState> enumHelper;

        @JsonCreator
        public static IterationFilterState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IterationFilterState>(IterationFilterState.class, false, true);
        }
    }
}

