/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define([ "jquery", "backbone", "underscore","app/util/StringUtil"], function($, Backbone, _,stringUtil) {
	"use strict";

	return Backbone.Model.extend({

		initialize : function(data){

			var self = this;

			this.set({
				selectedNode: data.selectedNode
			});
		},

		replicationModelToJson : function() {

            var replicationParameters = this.get("replicationParameters");
            var iterationId = parseInt(replicationParameters.iterationId);
			var newIteration = this.get("newIteration");
			var testPlan = this.get("testPlan");
			var keepTestSuites = replicationParameters.keepTestSuites;
			var keepAssignees = replicationParameters.keepAssignees;

			return JSON.stringify({
                sourceIterationId: iterationId,

                iterationName: newIteration.name,
                iterationReference: newIteration.reference,
                iterationDescription: newIteration.description,

                itpiIds: _.pluck(testPlan, 'itpi-id'),

                keepTestSuites: keepTestSuites,
                keepAssignees: keepAssignees
			});
		}
	});
});
