-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-5sbje3y3 (100.64.9.45)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-2.00.0.xml
-- Ran at: 16/02/2026 13:56
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.29.2
-- *********************************************************************

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
-- Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-2.00.0.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0::jthebault
-- Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
-- Update TM database version number
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

UPDATE CORE_CONFIG SET VALUE = '2.00.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0', 'jthebault', '../tm/tm.changelog-2.00.0.xml', NOW(), 2, '9:61e162fed2e24420d6e3c329444ae8b3', 'sql; update tableName=CORE_CONFIG', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
Update TM database version number', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-fix-missing-indexes::jthebault
CREATE INDEX idx_rln_created_by ON REQUIREMENT_LIBRARY_NODE(CREATED_BY);

CREATE INDEX idx_rln_last_modified_by ON REQUIREMENT_LIBRARY_NODE(LAST_MODIFIED_BY);

CREATE INDEX idx_tcln_created_by ON TEST_CASE_LIBRARY_NODE(CREATED_BY);

CREATE INDEX idx_tcln_last_modified_by ON TEST_CASE_LIBRARY_NODE(LAST_MODIFIED_BY);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-fix-missing-indexes', 'jthebault', '../tm/tm.changelog-2.00.0.xml', NOW(), 3, '9:eab3e68e7de66a9313581c5bb842a789', 'createIndex indexName=idx_rln_created_by, tableName=REQUIREMENT_LIBRARY_NODE; createIndex indexName=idx_rln_last_modified_by, tableName=REQUIREMENT_LIBRARY_NODE; createIndex indexName=idx_tcln_created_by, tableName=TEST_CASE_LIBRARY_NODE; createIn...', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-default-test-case-nature-icon-name::aboittiaux
-- Change default tc nature icons
UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE CODE = 'NAT_USER_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'dashboard' WHERE CODE = 'NAT_PERFORMANCE_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'protect' WHERE CODE = 'NAT_SECURITY_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'circular_arrows' WHERE CODE = 'NAT_ATDD';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox_empty' WHERE CODE = 'NAT_UNDEFINED';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE CODE = 'NAT_FUNCTIONAL_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'server' WHERE CODE = 'NAT_NON_FUNCTIONAL_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'briefcase' WHERE CODE = 'NAT_BUSINESS_TESTING';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-default-test-case-nature-icon-name', 'aboittiaux', '../tm/tm.changelog-2.00.0.xml', NOW(), 4, '9:3b8a05d1657d01a9e3bd3a22829b9f68', 'sql', 'Change default tc nature icons', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-default-test-case-type-icon-name::aboittiaux
-- Change default tc type icons
UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox_empty' WHERE CODE = 'TYP_UNDEFINED';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'task_completed' WHERE CODE = 'TYP_COMPLIANCE_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bug' WHERE CODE = 'TYP_CORRECTION_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'circled_up_right' WHERE CODE = 'TYP_EVOLUTION_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'circular_arrows' WHERE CODE = 'TYP_REGRESSION_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'journey' WHERE CODE = 'TYP_END_TO_END_TESTING';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'handshake' WHERE CODE = 'TYP_PARTNER_TESTING';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-default-test-case-type-icon-name', 'aboittiaux', '../tm/tm.changelog-2.00.0.xml', NOW(), 5, '9:12f9b292caab6b3977d480086b8cc270', 'sql', 'Change default tc type icons', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-default-requirement-category-icon-name::aboittiaux
-- Change default requirement category icons
UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE CODE = 'CAT_FUNCTIONAL';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'server' WHERE CODE = 'CAT_NON_FUNCTIONAL';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE CODE = 'CAT_USE_CASE';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'briefcase' WHERE CODE = 'CAT_BUSINESS';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'checked_checkbox' WHERE CODE = 'CAT_TEST_REQUIREMENT';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox_empty' WHERE CODE = 'CAT_UNDEFINED';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'puzzle' WHERE CODE = 'CAT_ERGONOMIC';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'dashboard' WHERE CODE = 'CAT_PERFORMANCE';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'key' WHERE CODE = 'CAT_TECHNICAL';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE CODE = 'CAT_USER_STORY';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'protect' WHERE CODE = 'CAT_SECURITY';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-default-requirement-category-icon-name', 'aboittiaux', '../tm/tm.changelog-2.00.0.xml', NOW(), 6, '9:dc1435124ad2177a4dcd02da5ea5f46b', 'sql', 'Change default requirement category icons', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-custom-infolist-icon-name::aboittiaux
-- Change infolist item icons
CREATE INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM(ICON_NAME);

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'checkmark' WHERE ICON_NAME = 'accept';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'checkmark' WHERE ICON_NAME = 'accept_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'add' WHERE ICON_NAME = 'add';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'alarm';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'anchor';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_add';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_cascade';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_double';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_edit';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_form';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_get';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_go';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_home';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_key';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_link';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_osx';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_osx_terminal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_put';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_boxes';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_contract';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_expand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_list';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_side_tree';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_split';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_tile_horizontal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_tile_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_columns';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_detail';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_gallery';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_icons';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_list';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_tile';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_xp';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_property' WHERE ICON_NAME = 'application_view_xp_terminal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'split' WHERE ICON_NAME = 'arrow_branch';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'split' WHERE ICON_NAME = 'arrow_divide';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_in';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_inout';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'merge' WHERE ICON_NAME = 'arrow_join';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'merge' WHERE ICON_NAME = 'arrow_merge';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_out';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_redo';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'restart' WHERE ICON_NAME = 'arrow_refresh';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'arrow_undo';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'asterisk_orange';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'attach' WHERE ICON_NAME = 'attach';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'attach' WHERE ICON_NAME = 'attach_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'award_star_gold';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bandaid';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'basket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bell';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bin_closed';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'blog';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'blueprint';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'blueprint_horizontal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bluetooth';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bomb';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_book';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_book_open';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_document';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bookmark' WHERE ICON_NAME = 'bookmark_folder';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'books';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_addresses';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_next';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_open';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'read' WHERE ICON_NAME = 'book_previous';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'box';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'brick';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'bricks';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'briefcase' WHERE ICON_NAME = 'briefcase';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bug' WHERE ICON_NAME = 'bug';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'buildings';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'add' WHERE ICON_NAME = 'bullet_add_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'add' WHERE ICON_NAME = 'bullet_add_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'key' WHERE ICON_NAME = 'bullet_key';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cake';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'calculator';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'calendar' WHERE ICON_NAME = 'calendar_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'calendar' WHERE ICON_NAME = 'calendar_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'camera';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cancel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'car';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cart';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bar_chart' WHERE ICON_NAME = 'chart_bar';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'combo_chart' WHERE ICON_NAME = 'chart_curve';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'combo_chart' WHERE ICON_NAME = 'chart_line';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'flow_chart' WHERE ICON_NAME = 'chart_organisation';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'pie_chart' WHERE ICON_NAME = 'chart_pie';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_document' WHERE ICON_NAME = 'clipboard_paste_image';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_document' WHERE ICON_NAME = 'clipboard_sign';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'new_document' WHERE ICON_NAME = 'clipboard_text';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'clock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'settings' WHERE ICON_NAME = 'cog';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'coins';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'send_backward' WHERE ICON_NAME = 'color_swatch_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'color_swatch_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'topic' WHERE ICON_NAME = 'comment';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'compass';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'compress';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE ICON_NAME = 'computer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'connect';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'contrast';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_eject';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_end';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_equalizer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_fastforward';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_pause';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_play';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_repeat';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_rewind';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_start';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_stop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'control_wheel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_count';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_count_up';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_reset';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'counter_stop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_octagon';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_octagon_fram';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_shield';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cancel' WHERE ICON_NAME = 'cross_shield_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'crown';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'crown_bronze';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'crown_silver';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'css';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cursor';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'cut';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'dashboard' WHERE ICON_NAME = 'dashboard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'calendar' WHERE ICON_NAME = 'data';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'database' WHERE ICON_NAME = 'database';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'database' WHERE ICON_NAME = 'databases';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'unavailable' WHERE ICON_NAME = 'delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'delivery';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'desktop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'desktop_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'direction';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'disconnect';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'disk';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_access';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_convert';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_excel_csv';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_excel_table';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_film';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_illustrator';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_music';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_music_playlist';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_offlice';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_page';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_page_previous';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_pdf';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_photoshop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_resize';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_resize_actual';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_shred';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_stand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_table';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_tag';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'doc_text_image';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'door';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'door_in';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'drawer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'drink';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'drink_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_burn';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_cd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_cd_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_disk';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_go';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_link';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_network';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'drive_rename';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'save' WHERE ICON_NAME = 'dvd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'email';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'email_open';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'email_open_image';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_evilgrin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_grin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_happy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_smile';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_surprised';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_tongue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_unhappy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_waii';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'emoticon_wink';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'envelope';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'envelope_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'error' WHERE ICON_NAME = 'error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'box_important' WHERE ICON_NAME = 'exclamation';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'box_important' WHERE ICON_NAME = 'exclamation_octagon_fram';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'eye' WHERE ICON_NAME = 'eye';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'feed';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'feed_ballon';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'feed_document';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'female';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'film';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'films';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'find';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'flag_filled' WHERE ICON_NAME = 'flag_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'folder' WHERE ICON_NAME = 'folder';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'font_size' WHERE ICON_NAME = 'font';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'funnel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'grid';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'grid_dot';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user_account' WHERE ICON_NAME = 'group';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'maintenance' WHERE ICON_NAME = 'hammer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'maintenance' WHERE ICON_NAME = 'hammer_screwdriver';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'hand' WHERE ICON_NAME = 'hand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'hand' WHERE ICON_NAME = 'hand_point';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_empty';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_half';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'heart_outline' WHERE ICON_NAME = 'heart_small';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'help' WHERE ICON_NAME = 'help';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'edit' WHERE ICON_NAME = 'highlighter';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'house';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'html';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'images';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'image_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'image_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'inbox';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ipod';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ipod_cast';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'joystick';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'key' WHERE ICON_NAME = 'key';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'keyboard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layers';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layer_treansparent';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_header_footer_3';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_header_footer_3_mix';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_join';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_join_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select_content';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select_footer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_select_sidebar';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_split';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'layout_split_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'lifebuoy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'reflector_bulb' WHERE ICON_NAME = 'lightbulb';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'reflector_bulb' WHERE ICON_NAME = 'lightbulb_off';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'lightning_bolt' WHERE ICON_NAME = 'lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'link' WHERE ICON_NAME = 'link';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'link' WHERE ICON_NAME = 'link_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'lock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'lock_unlock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'magnet';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'magnifier';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'magnifier_zoom_in';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'male';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'map';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'marker';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'medal_bronze_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'medal_gold_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'media_player_small_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'microphone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'mobile_phone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_dollar';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_euro';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_pound';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'us_dollar' WHERE ICON_NAME = 'money_yen';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE ICON_NAME = 'monitor';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'mouse';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'music';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'music_beam';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'neutral';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'new';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'newspaper';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'document' WHERE ICON_NAME = 'note';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'nuclear';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'package';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_2_copy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_code';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_copy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_excel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_paste';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_red';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_refresh';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_save';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_cplusplus';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_csharp';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_cup';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_database';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_delete';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_dvd';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_edit';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_error';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_excel';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_find';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_flash';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_freehand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_gear';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_get';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_paintbrush';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_paste';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_php';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_picture';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_powerpoint';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_put';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_ruby';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_stack';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_star';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_swoosh';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_text';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_text_width';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_tux';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_vector';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_visualstudio';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_width';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_word';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_world';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_wrench';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'page_white_zip';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'edit' WHERE ICON_NAME = 'paintbrush';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paintcan';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'palette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paper_bag';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paste_plain';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'paste_word';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'edit' WHERE ICON_NAME = 'pencil';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'photo';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'photos';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'photo_album';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'piano';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'picture';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pilcrow';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pill';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'pipette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'plaing_card';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'plug';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'puzzle' WHERE ICON_NAME = 'plugin';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'printer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'projection_screen';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'projection_screen_present';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rainbow';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bar_chart' WHERE ICON_NAME = 'report';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'bar_chart' WHERE ICON_NAME = 'reporting_chart';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'statistics' WHERE ICON_NAME = 'reporting_dashboard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'reporting_datatable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'traffic_light' WHERE ICON_NAME = 'reporting_indicator';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'file' WHERE ICON_NAME = 'reporting_report';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rocket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rosette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'rss';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruby';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_crop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ruler_triangle';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'safe';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'sheet_of_paper' WHERE ICON_NAME = 'script';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'selection';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'selection_select';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'server' WHERE ICON_NAME = 'server';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shading';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_bottom';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_center';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_middle';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_aling_top';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_flip_horizontal';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_flip_vertical';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_group';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_handles';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_back';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_backwards';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_forwards';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_move_front';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'shape_square';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'protect' WHERE ICON_NAME = 'shield';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sitemap';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'slide';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'slides';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'slides_stack';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_confuse';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_cool';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_cry';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_fat';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_mad';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_red';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_roll';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_slim';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'smiley_yell';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'socket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sockets';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_alphabet';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_date';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_disable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_number';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_price';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_quantity';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sort_rating';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sound';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sound_note';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'spellcheck';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_8ball';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_basketball';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_football';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_golf';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_raquet';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_shuttlecock';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_soccer';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sport_tennis';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'stamp';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'star' WHERE ICON_NAME = 'star_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'star' WHERE ICON_NAME = 'star_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'status_online';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'stop';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'style';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sum';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'sum_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'switch';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'tab';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'grid' WHERE ICON_NAME = 'table';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'price_tag' WHERE ICON_NAME = 'tag';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'price_tag' WHERE ICON_NAME = 'tag_blue';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'accuracy' WHERE ICON_NAME = 'target';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'telephone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'monitor' WHERE ICON_NAME = 'television';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'textfield';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'textfield_rename';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_center';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_justify';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_align_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_allcaps';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_bold';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_columns';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_dropcaps';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_heading_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_horizontalrule';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_indent';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_indent_remove';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_italic';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_kerning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_letterspacing';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_letter_omega';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_linespacing';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_list_bullets';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_list_numbers';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_lowercase';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_bottom';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_left';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_right';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_padding_top';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_signature';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_smallcaps';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_strikethrough';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'text_subscript';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'ticket' WHERE ICON_NAME = 'ticket';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'timeline_marker';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'traffic_light' WHERE ICON_NAME = 'traffic';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'transmit';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'trophy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'trophy_bronze';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'medal' WHERE ICON_NAME = 'trophy_silver';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_combo_box';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_saccordion';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_slider_1';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_slider_2';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_bottom';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_content';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_disable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_tab_side';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_text_field_hidden';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'ui_text_field_password';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'umbrella';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_black_female';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_business';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_business_boss';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_female';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_silhouette';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_thief';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'user' WHERE ICON_NAME = 'user_thief_baldie';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'vcard';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'vector';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'sand_watch' WHERE ICON_NAME = 'wait';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall_break';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall_brick';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wall_disable';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'wand';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cloud' WHERE ICON_NAME = 'weather_clouds';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'partly_cloudy_day' WHERE ICON_NAME = 'weather_cloudy';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'cloud_lightning' WHERE ICON_NAME = 'weather_lightning';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'storm' WHERE ICON_NAME = 'weather_rain';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'storm' WHERE ICON_NAME = 'weather_snow';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'sun' WHERE ICON_NAME = 'weather_sun';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'webcam';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'world';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'zone';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'zones';

UPDATE INFO_LIST_ITEM SET ICON_NAME = 'indeterminate_checkbox' WHERE ICON_NAME = 'zone_money';

DROP INDEX idx_info_list_item_icon_name_temp;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-custom-infolist-icon-name', 'aboittiaux', '../tm/tm.changelog-2.00.0.xml', NOW(), 7, '9:bb250a581f8dec45cd0640f4d3efbb3d', 'createIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM; sql; dropIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM', 'Change infolist item icons', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-execution-tc-nat-icon-name::aboittiaux
-- Change execution tc nat icon name
CREATE INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION(TC_NAT_ICON_NAME);

CREATE INDEX idx_exec_tc_nat_code_temp ON EXECUTION(TC_NAT_CODE);

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'checkmark' WHERE TC_NAT_ICON_NAME = 'accept';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'checkmark' WHERE TC_NAT_ICON_NAME = 'accept_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'add' WHERE TC_NAT_ICON_NAME = 'add';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'alarm';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'anchor';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_add';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_cascade';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_double';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_edit';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_form';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_get';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_go';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_home';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_key';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_link';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_osx';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_osx_terminal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_put';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_boxes';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_contract';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_expand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_list';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_side_tree';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_split';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_tile_horizontal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_tile_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_columns';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_detail';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_gallery';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_icons';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_list';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_tile';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_xp';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_property' WHERE TC_NAT_ICON_NAME = 'application_view_xp_terminal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'split' WHERE TC_NAT_ICON_NAME = 'arrow_branch';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'split' WHERE TC_NAT_ICON_NAME = 'arrow_divide';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_in';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_inout';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'merge' WHERE TC_NAT_ICON_NAME = 'arrow_join';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'merge' WHERE TC_NAT_ICON_NAME = 'arrow_merge';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_out';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_redo';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'restart' WHERE TC_NAT_ICON_NAME = 'arrow_refresh';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'arrow_undo';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'asterisk_orange';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'attach' WHERE TC_NAT_ICON_NAME = 'attach';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'attach' WHERE TC_NAT_ICON_NAME = 'attach_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'award_star_gold';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bandaid';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'basket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bell';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bin_closed';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'blog';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'blueprint';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'blueprint_horizontal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bluetooth';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bomb';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_book';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_book_open';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_document';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bookmark' WHERE TC_NAT_ICON_NAME = 'bookmark_folder';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'books';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_addresses';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_next';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_open';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'read' WHERE TC_NAT_ICON_NAME = 'book_previous';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'box';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'brick';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'bricks';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'briefcase' WHERE TC_NAT_ICON_NAME = 'briefcase';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bug' WHERE TC_NAT_ICON_NAME = 'bug';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'buildings';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'add' WHERE TC_NAT_ICON_NAME = 'bullet_add_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'add' WHERE TC_NAT_ICON_NAME = 'bullet_add_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'key' WHERE TC_NAT_ICON_NAME = 'bullet_key';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cake';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'calculator';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'calendar' WHERE TC_NAT_ICON_NAME = 'calendar_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'calendar' WHERE TC_NAT_ICON_NAME = 'calendar_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'camera';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cancel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'car';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cart';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bar_chart' WHERE TC_NAT_ICON_NAME = 'chart_bar';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'combo_chart' WHERE TC_NAT_ICON_NAME = 'chart_curve';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'combo_chart' WHERE TC_NAT_ICON_NAME = 'chart_line';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'flow_chart' WHERE TC_NAT_ICON_NAME = 'chart_organisation';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'pie_chart' WHERE TC_NAT_ICON_NAME = 'chart_pie';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_document' WHERE TC_NAT_ICON_NAME = 'clipboard_paste_image';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_document' WHERE TC_NAT_ICON_NAME = 'clipboard_sign';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'new_document' WHERE TC_NAT_ICON_NAME = 'clipboard_text';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'clock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'settings' WHERE TC_NAT_ICON_NAME = 'cog';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'coins';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'send_backward' WHERE TC_NAT_ICON_NAME = 'color_swatch_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'color_swatch_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'topic' WHERE TC_NAT_ICON_NAME = 'comment';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'compass';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'compress';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'monitor' WHERE TC_NAT_ICON_NAME = 'computer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'connect';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'contrast';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_eject';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_end';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_equalizer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_fastforward';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_pause';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_play';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_repeat';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_rewind';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_start';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_stop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'control_wheel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_count';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_count_up';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_reset';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'counter_stop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_octagon';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_octagon_fram';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_shield';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cancel' WHERE TC_NAT_ICON_NAME = 'cross_shield_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'crown';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'crown_bronze';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'crown_silver';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'css';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cursor';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'cut';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'dashboard' WHERE TC_NAT_ICON_NAME = 'dashboard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'calendar' WHERE TC_NAT_ICON_NAME = 'data';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'database' WHERE TC_NAT_ICON_NAME = 'database';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'database' WHERE TC_NAT_ICON_NAME = 'databases';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'unavailable' WHERE TC_NAT_ICON_NAME = 'delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'delivery';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'desktop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'desktop_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'direction';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'disconnect';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'disk';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_access';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_convert';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_excel_csv';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_excel_table';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_film';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_illustrator';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_music';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_music_playlist';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_offlice';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_page';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_page_previous';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_pdf';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_photoshop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_resize';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_resize_actual';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_shred';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_stand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_table';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_tag';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'doc_text_image';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'door';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'door_in';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'drawer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'drink';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'drink_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_burn';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_cd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_cd_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_disk';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_go';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_link';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_network';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'drive_rename';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'save' WHERE TC_NAT_ICON_NAME = 'dvd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'email';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'email_open';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'email_open_image';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_evilgrin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_grin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_happy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_smile';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_surprised';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_tongue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_unhappy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_waii';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'emoticon_wink';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'envelope';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'envelope_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'error' WHERE TC_NAT_ICON_NAME = 'error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'box_important' WHERE TC_NAT_ICON_NAME = 'exclamation';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'box_important' WHERE TC_NAT_ICON_NAME = 'exclamation_octagon_fram';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'eye' WHERE TC_NAT_ICON_NAME = 'eye';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'feed';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'feed_ballon';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'feed_document';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'female';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'film';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'films';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'find';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'flag_filled' WHERE TC_NAT_ICON_NAME = 'flag_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'folder' WHERE TC_NAT_ICON_NAME = 'folder';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'font_size' WHERE TC_NAT_ICON_NAME = 'font';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'funnel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'grid';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'grid_dot';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user_account' WHERE TC_NAT_ICON_NAME = 'group';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'maintenance' WHERE TC_NAT_ICON_NAME = 'hammer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'maintenance' WHERE TC_NAT_ICON_NAME = 'hammer_screwdriver';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'hand' WHERE TC_NAT_ICON_NAME = 'hand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'hand' WHERE TC_NAT_ICON_NAME = 'hand_point';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_empty';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_half';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'heart_outline' WHERE TC_NAT_ICON_NAME = 'heart_small';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'help' WHERE TC_NAT_ICON_NAME = 'help';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'edit' WHERE TC_NAT_ICON_NAME = 'highlighter';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'house';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'html';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'images';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'image_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'image_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'inbox';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ipod';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ipod_cast';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'joystick';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'key' WHERE TC_NAT_ICON_NAME = 'key';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'keyboard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layers';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layer_treansparent';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'layout_header_footer_3';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'layout_header_footer_3_mix';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_join';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_join_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select_content';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select_footer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_select_sidebar';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_split';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'layout_split_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'lifebuoy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'reflector_bulb' WHERE TC_NAT_ICON_NAME = 'lightbulb';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'reflector_bulb' WHERE TC_NAT_ICON_NAME = 'lightbulb_off';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'lightning_bolt' WHERE TC_NAT_ICON_NAME = 'lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'link' WHERE TC_NAT_ICON_NAME = 'link';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'link' WHERE TC_NAT_ICON_NAME = 'link_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'lock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'lock_unlock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'magnet';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'magnifier';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'magnifier_zoom_in';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'male';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'map';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'marker';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'medal_bronze_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'medal_gold_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'media_player_small_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'microphone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'mobile_phone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_dollar';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_euro';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_pound';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'us_dollar' WHERE TC_NAT_ICON_NAME = 'money_yen';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'monitor' WHERE TC_NAT_ICON_NAME = 'monitor';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'mouse';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'music';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'music_beam';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'neutral';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'new';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'newspaper';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_CODE in ('NAT_UNDEFINED',
      'NAT_FUNCTIONAL_TESTING','NAT_BUSINESS_TESTING','NAT_USER_TESTING','NAT_NON_FUNCTIONAL_TESTING','NAT_PERFORMANCE_TESTING','NAT_SECURITY_TESTING','NAT_ATDD');

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'document' WHERE TC_NAT_ICON_NAME = 'note';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'nuclear';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'package';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_2_copy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_code';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_copy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_excel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_paste';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_red';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_refresh';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_save';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_cplusplus';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_csharp';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_cup';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_database';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_delete';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_dvd';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_edit';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_error';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_excel';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_find';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_flash';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_freehand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_gear';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_get';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_paintbrush';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_paste';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_php';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_picture';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_powerpoint';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_put';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_ruby';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_stack';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_star';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_swoosh';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_text';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_text_width';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_tux';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_vector';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_visualstudio';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_width';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_word';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_world';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_wrench';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'page_white_zip';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'edit' WHERE TC_NAT_ICON_NAME = 'paintbrush';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paintcan';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'palette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paper_bag';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paste_plain';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'paste_word';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'edit' WHERE TC_NAT_ICON_NAME = 'pencil';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'photo';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'photos';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'photo_album';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'piano';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'picture';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pilcrow';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pill';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'pipette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'plaing_card';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'plug';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'puzzle' WHERE TC_NAT_ICON_NAME = 'plugin';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'printer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'projection_screen';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'projection_screen_present';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rainbow';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bar_chart' WHERE TC_NAT_ICON_NAME = 'report';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'bar_chart' WHERE TC_NAT_ICON_NAME = 'reporting_chart';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'statistics' WHERE TC_NAT_ICON_NAME = 'reporting_dashboard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'reporting_datatable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'traffic_light' WHERE TC_NAT_ICON_NAME = 'reporting_indicator';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'file' WHERE TC_NAT_ICON_NAME = 'reporting_report';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rocket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rosette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'rss';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruby';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_crop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ruler_triangle';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'safe';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'sheet_of_paper' WHERE TC_NAT_ICON_NAME = 'script';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'selection';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'selection_select';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'server' WHERE TC_NAT_ICON_NAME = 'server';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shading';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_bottom';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_center';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_middle';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_aling_top';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_flip_horizontal';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_flip_vertical';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_group';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_handles';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_back';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_backwards';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_forwards';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_move_front';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'shape_square';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'protect' WHERE TC_NAT_ICON_NAME = 'shield';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sitemap';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'slide';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'slides';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'slides_stack';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_confuse';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_cool';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_cry';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_fat';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_mad';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_red';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_roll';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_slim';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'smiley_yell';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'socket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sockets';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_alphabet';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_date';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_disable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_number';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_price';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_quantity';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sort_rating';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sound';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sound_note';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'spellcheck';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_8ball';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_basketball';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_football';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_golf';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_raquet';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_shuttlecock';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_soccer';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sport_tennis';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'stamp';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'star' WHERE TC_NAT_ICON_NAME = 'star_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'star' WHERE TC_NAT_ICON_NAME = 'star_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'status_online';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'stop';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'style';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sum';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'sum_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'switch';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'tab';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'grid' WHERE TC_NAT_ICON_NAME = 'table';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'price_tag' WHERE TC_NAT_ICON_NAME = 'tag';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'price_tag' WHERE TC_NAT_ICON_NAME = 'tag_blue';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'accuracy' WHERE TC_NAT_ICON_NAME = 'target';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'telephone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'monitor' WHERE TC_NAT_ICON_NAME = 'television';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'textfield';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'textfield_rename';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_center';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_justify';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_align_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_allcaps';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_bold';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_columns';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_dropcaps';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_heading_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_horizontalrule';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_indent';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_indent_remove';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_italic';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_kerning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_letterspacing';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_letter_omega';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_linespacing';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_list_bullets';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_list_numbers';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_lowercase';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_bottom';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_left';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_right';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_padding_top';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_signature';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_smallcaps';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_strikethrough';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'text_subscript';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'ticket' WHERE TC_NAT_ICON_NAME = 'ticket';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'timeline_marker';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'traffic_light' WHERE TC_NAT_ICON_NAME = 'traffic';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'transmit';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'trophy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'trophy_bronze';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'medal' WHERE TC_NAT_ICON_NAME = 'trophy_silver';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_combo_box';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_saccordion';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_slider_1';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_slider_2';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_bottom';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_content';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_disable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_tab_side';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'ui_text_field_hidden';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME =
      'ui_text_field_password';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'umbrella';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_black_female';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_business';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_business_boss';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_female';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_silhouette';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_thief';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'user' WHERE TC_NAT_ICON_NAME = 'user_thief_baldie';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'vcard';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'vector';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'sand_watch' WHERE TC_NAT_ICON_NAME = 'wait';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall_break';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall_brick';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wall_disable';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'wand';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cloud' WHERE TC_NAT_ICON_NAME = 'weather_clouds';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'partly_cloudy_day' WHERE TC_NAT_ICON_NAME = 'weather_cloudy';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'cloud_lightning' WHERE TC_NAT_ICON_NAME = 'weather_lightning';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'storm' WHERE TC_NAT_ICON_NAME = 'weather_rain';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'storm' WHERE TC_NAT_ICON_NAME = 'weather_snow';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'sun' WHERE TC_NAT_ICON_NAME = 'weather_sun';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'webcam';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'world';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'zone';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'zones';

UPDATE EXECUTION SET TC_NAT_ICON_NAME = 'indeterminate_checkbox' WHERE TC_NAT_ICON_NAME = 'zone_money';

DROP INDEX idx_exec_tc_nat_icon_name_temp;

DROP INDEX idx_exec_tc_nat_code_temp;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-execution-tc-nat-icon-name', 'aboittiaux', '../tm/tm.changelog-2.00.0.xml', NOW(), 8, '9:471c6a55ce7a6bf421a7c2878f5ea25d', 'createIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; dropIndex indexName=idx_...', 'Change execution tc nat icon name', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-update-execution-tc-typ-icon-name::aboittiaux
-- Change execution tc typ icon name
CREATE INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION(TC_TYP_ICON_NAME);

CREATE INDEX idx_exec_tc_typ_code_temp ON EXECUTION(TC_TYP_CODE);

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'checkmark' WHERE TC_TYP_ICON_NAME = 'accept';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'checkmark' WHERE TC_TYP_ICON_NAME = 'accept_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'add' WHERE TC_TYP_ICON_NAME = 'add';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'alarm';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'anchor';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_add';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_cascade';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_double';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_edit';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_form';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_get';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_go';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_home';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_key';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_link';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_osx';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_osx_terminal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_put';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_boxes';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_contract';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_expand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_list';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_side_tree';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_split';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_tile_horizontal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_tile_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_columns';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_detail';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_gallery';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_icons';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_list';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_tile';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_xp';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_property' WHERE TC_TYP_ICON_NAME = 'application_view_xp_terminal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'split' WHERE TC_TYP_ICON_NAME = 'arrow_branch';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'split' WHERE TC_TYP_ICON_NAME = 'arrow_divide';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_in';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_inout';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'merge' WHERE TC_TYP_ICON_NAME = 'arrow_join';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'merge' WHERE TC_TYP_ICON_NAME = 'arrow_merge';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_out';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_redo';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'restart' WHERE TC_TYP_ICON_NAME = 'arrow_refresh';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'arrow_undo';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'asterisk_orange';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'attach' WHERE TC_TYP_ICON_NAME = 'attach';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'attach' WHERE TC_TYP_ICON_NAME = 'attach_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'award_star_gold';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bandaid';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'basket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bell';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bin_closed';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'blog';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'blueprint';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'blueprint_horizontal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bluetooth';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bomb';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_book';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_book_open';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_document';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bookmark' WHERE TC_TYP_ICON_NAME = 'bookmark_folder';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'books';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_addresses';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_next';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_open';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'read' WHERE TC_TYP_ICON_NAME = 'book_previous';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'box';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'brick';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'bricks';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'briefcase' WHERE TC_TYP_ICON_NAME = 'briefcase';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bug' WHERE TC_TYP_ICON_NAME = 'bug';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'buildings';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'add' WHERE TC_TYP_ICON_NAME = 'bullet_add_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'add' WHERE TC_TYP_ICON_NAME = 'bullet_add_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'key' WHERE TC_TYP_ICON_NAME = 'bullet_key';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cake';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'calculator';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'calendar' WHERE TC_TYP_ICON_NAME = 'calendar_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'calendar' WHERE TC_TYP_ICON_NAME = 'calendar_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'camera';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cancel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'car';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cart';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bar_chart' WHERE TC_TYP_ICON_NAME = 'chart_bar';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'combo_chart' WHERE TC_TYP_ICON_NAME = 'chart_curve';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'combo_chart' WHERE TC_TYP_ICON_NAME = 'chart_line';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'flow_chart' WHERE TC_TYP_ICON_NAME = 'chart_organisation';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'pie_chart' WHERE TC_TYP_ICON_NAME = 'chart_pie';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_document' WHERE TC_TYP_ICON_NAME = 'clipboard_paste_image';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_document' WHERE TC_TYP_ICON_NAME = 'clipboard_sign';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'new_document' WHERE TC_TYP_ICON_NAME = 'clipboard_text';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'clock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'settings' WHERE TC_TYP_ICON_NAME = 'cog';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'coins';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'send_backward' WHERE TC_TYP_ICON_NAME = 'color_swatch_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'color_swatch_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'topic' WHERE TC_TYP_ICON_NAME = 'comment';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'compass';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'compress';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'monitor' WHERE TC_TYP_ICON_NAME = 'computer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'connect';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'contrast';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_eject';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_end';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_equalizer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_fastforward';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_pause';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_play';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_repeat';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_rewind';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_start';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_stop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'control_wheel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_count';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_count_up';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_reset';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'counter_stop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_octagon';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_octagon_fram';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_shield';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cancel' WHERE TC_TYP_ICON_NAME = 'cross_shield_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'crown';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'crown_bronze';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'crown_silver';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'css';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cursor';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'cut';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'dashboard' WHERE TC_TYP_ICON_NAME = 'dashboard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'calendar' WHERE TC_TYP_ICON_NAME = 'data';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'database' WHERE TC_TYP_ICON_NAME = 'database';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'database' WHERE TC_TYP_ICON_NAME = 'databases';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'unavailable' WHERE TC_TYP_ICON_NAME = 'delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'delivery';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'desktop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'desktop_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'direction';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'disconnect';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'disk';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_access';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_convert';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_excel_csv';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_excel_table';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_film';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_illustrator';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_music';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_music_playlist';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_offlice';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_page';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_page_previous';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_pdf';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_photoshop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_resize';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_resize_actual';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_shred';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_stand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_table';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_tag';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'doc_text_image';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'door';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'door_in';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'drawer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'drink';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'drink_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_burn';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_cd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_cd_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_disk';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_go';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_link';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_network';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'drive_rename';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'save' WHERE TC_TYP_ICON_NAME = 'dvd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'email';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'email_open';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'email_open_image';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_evilgrin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_grin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_happy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_smile';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_surprised';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_tongue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_unhappy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_waii';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'emoticon_wink';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'envelope';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'envelope_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'error' WHERE TC_TYP_ICON_NAME = 'error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'box_important' WHERE TC_TYP_ICON_NAME = 'exclamation';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'box_important' WHERE TC_TYP_ICON_NAME = 'exclamation_octagon_fram';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'eye' WHERE TC_TYP_ICON_NAME = 'eye';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'feed';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'feed_ballon';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'feed_document';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'female';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'film';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'films';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'find';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'flag_filled' WHERE TC_TYP_ICON_NAME = 'flag_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'folder' WHERE TC_TYP_ICON_NAME = 'folder';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'font_size' WHERE TC_TYP_ICON_NAME = 'font';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'funnel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'grid';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'grid_dot';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user_account' WHERE TC_TYP_ICON_NAME = 'group';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'maintenance' WHERE TC_TYP_ICON_NAME = 'hammer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'maintenance' WHERE TC_TYP_ICON_NAME = 'hammer_screwdriver';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'hand' WHERE TC_TYP_ICON_NAME = 'hand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'hand' WHERE TC_TYP_ICON_NAME = 'hand_point';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_empty';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_half';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'heart_outline' WHERE TC_TYP_ICON_NAME = 'heart_small';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'help' WHERE TC_TYP_ICON_NAME = 'help';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'edit' WHERE TC_TYP_ICON_NAME = 'highlighter';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'house';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'html';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'images';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'image_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'image_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'inbox';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ipod';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ipod_cast';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'joystick';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'key' WHERE TC_TYP_ICON_NAME = 'key';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'keyboard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layers';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layer_treansparent';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'layout_header_footer_3';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'layout_header_footer_3_mix';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_join';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_join_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select_content';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select_footer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_select_sidebar';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_split';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'layout_split_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'lifebuoy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'reflector_bulb' WHERE TC_TYP_ICON_NAME = 'lightbulb';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'reflector_bulb' WHERE TC_TYP_ICON_NAME = 'lightbulb_off';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'lightning_bolt' WHERE TC_TYP_ICON_NAME = 'lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'link' WHERE TC_TYP_ICON_NAME = 'link';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'link' WHERE TC_TYP_ICON_NAME = 'link_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'lock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'lock_unlock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'magnet';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'magnifier';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'magnifier_zoom_in';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'male';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'map';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'marker';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'medal_bronze_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'medal_gold_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'media_player_small_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'microphone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'mobile_phone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_dollar';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_euro';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_pound';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'us_dollar' WHERE TC_TYP_ICON_NAME = 'money_yen';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'monitor' WHERE TC_TYP_ICON_NAME = 'monitor';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'mouse';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'music';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'music_beam';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'neutral';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'new';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'newspaper';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_CODE in ('TYP_UNDEFINED',
      'TYP_COMPLIANCE_TESTING', 'TYP_CORRECTION_TESTING', 'TYP_EVOLUTION_TESTING', 'TYP_REGRESSION_TESTING',
      'TYP_END_TO_END_TESTING', 'TYP_PARTNER_TESTING');

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'document' WHERE TC_TYP_ICON_NAME = 'note';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'nuclear';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'package';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_2_copy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_code';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_copy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_excel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_paste';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_red';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_refresh';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_save';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_cplusplus';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_csharp';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_cup';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_database';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_delete';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_dvd';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_edit';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_error';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_excel';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_find';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_flash';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_freehand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_gear';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_get';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_paintbrush';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_paste';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_php';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_picture';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_powerpoint';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_put';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_ruby';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_stack';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_star';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_swoosh';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_text';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_text_width';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_tux';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_vector';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_visualstudio';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_width';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_word';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_world';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_wrench';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'page_white_zip';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'edit' WHERE TC_TYP_ICON_NAME = 'paintbrush';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paintcan';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'palette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paper_bag';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paste_plain';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'paste_word';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'edit' WHERE TC_TYP_ICON_NAME = 'pencil';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'photo';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'photos';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'photo_album';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'piano';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'picture';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pilcrow';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pill';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'pipette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'plaing_card';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'plug';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'puzzle' WHERE TC_TYP_ICON_NAME = 'plugin';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'printer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'projection_screen';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'projection_screen_present';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rainbow';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bar_chart' WHERE TC_TYP_ICON_NAME = 'report';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'bar_chart' WHERE TC_TYP_ICON_NAME = 'reporting_chart';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'statistics' WHERE TC_TYP_ICON_NAME = 'reporting_dashboard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'reporting_datatable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'traffic_light' WHERE TC_TYP_ICON_NAME = 'reporting_indicator';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'file' WHERE TC_TYP_ICON_NAME = 'reporting_report';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rocket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rosette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'rss';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruby';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_crop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ruler_triangle';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'safe';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'sheet_of_paper' WHERE TC_TYP_ICON_NAME = 'script';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'selection';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'selection_select';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'server' WHERE TC_TYP_ICON_NAME = 'server';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shading';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_bottom';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_center';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_middle';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_aling_top';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_flip_horizontal';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_flip_vertical';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_group';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_handles';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_back';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_backwards';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_forwards';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_move_front';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'shape_square';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'protect' WHERE TC_TYP_ICON_NAME = 'shield';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sitemap';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'slide';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'slides';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'slides_stack';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_confuse';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_cool';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_cry';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_fat';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_mad';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_red';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_roll';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_slim';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'smiley_yell';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'socket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sockets';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_alphabet';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_date';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_disable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_number';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_price';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_quantity';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sort_rating';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sound';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sound_note';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'spellcheck';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_8ball';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_basketball';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_football';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_golf';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_raquet';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_shuttlecock';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_soccer';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sport_tennis';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'stamp';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'star' WHERE TC_TYP_ICON_NAME = 'star_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'star' WHERE TC_TYP_ICON_NAME = 'star_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'status_online';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'stop';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'style';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sum';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'sum_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'switch';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'tab';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'grid' WHERE TC_TYP_ICON_NAME = 'table';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'price_tag' WHERE TC_TYP_ICON_NAME = 'tag';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'price_tag' WHERE TC_TYP_ICON_NAME = 'tag_blue';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'accuracy' WHERE TC_TYP_ICON_NAME = 'target';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'telephone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'monitor' WHERE TC_TYP_ICON_NAME = 'television';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'textfield';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'textfield_rename';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_center';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_justify';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_align_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_allcaps';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_bold';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_columns';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_dropcaps';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_heading_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_horizontalrule';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_indent';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_indent_remove';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_italic';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_kerning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_letterspacing';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_letter_omega';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_linespacing';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_list_bullets';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_list_numbers';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_lowercase';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_bottom';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_left';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_right';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_padding_top';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_signature';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_smallcaps';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_strikethrough';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'text_subscript';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'ticket' WHERE TC_TYP_ICON_NAME = 'ticket';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'timeline_marker';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'traffic_light' WHERE TC_TYP_ICON_NAME = 'traffic';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'transmit';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'trophy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'trophy_bronze';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'medal' WHERE TC_TYP_ICON_NAME = 'trophy_silver';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_combo_box';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_saccordion';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_slider_1';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_slider_2';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_bottom';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_content';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_disable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_tab_side';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'ui_text_field_hidden';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME =
      'ui_text_field_password';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'umbrella';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_black_female';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_business';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_business_boss';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_female';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_silhouette';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_thief';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'user' WHERE TC_TYP_ICON_NAME = 'user_thief_baldie';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'vcard';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'vector';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'sand_watch' WHERE TC_TYP_ICON_NAME = 'wait';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall_break';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall_brick';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wall_disable';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'wand';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cloud' WHERE TC_TYP_ICON_NAME = 'weather_clouds';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'partly_cloudy_day' WHERE TC_TYP_ICON_NAME = 'weather_cloudy';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'cloud_lightning' WHERE TC_TYP_ICON_NAME = 'weather_lightning';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'storm' WHERE TC_TYP_ICON_NAME = 'weather_rain';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'storm' WHERE TC_TYP_ICON_NAME = 'weather_snow';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'sun' WHERE TC_TYP_ICON_NAME = 'weather_sun';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'webcam';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'world';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'zone';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'zones';

UPDATE EXECUTION SET TC_TYP_ICON_NAME = 'indeterminate_checkbox' WHERE TC_TYP_ICON_NAME = 'zone_money';

DROP INDEX idx_exec_tc_typ_icon_name_temp;

DROP INDEX idx_exec_tc_typ_code_temp;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-update-execution-tc-typ-icon-name', 'aboittiaux', '../tm/tm.changelog-2.00.0.xml', NOW(), 9, '9:b72d1663401085936efe56791b658462', 'createIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_typ_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; dropIndex indexName=idx_...', 'Change execution tc typ icon name', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-grant-attach-permission-on-projects-to-pms::pckerneis
-- Grant ATTACH permission on projects to project managers
insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values
      (5, 1, 1024);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-grant-attach-permission-on-projects-to-pms', 'pckerneis', '../tm/tm.changelog-2.00.0.xml', NOW(), 10, '9:125818760675ce4ffb8d7b049038e77d', 'sql', 'Grant ATTACH permission on projects to project managers', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-missing-entries-in-awln_relationship_closure::jlor
-- insert missing entries in awln_relationship_closure: former projects data were not inserted.
INSERT INTO AWLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID, DESCENDANT_ID, DEPTH)
      SELECT n.awln_id, n.awln_id, 0
      FROM ACTION_WORD_LIBRARY_NODE n
      LEFT JOIN AWLN_RELATIONSHIP_CLOSURE cl on n.awln_id = cl.ancestor_id
      WHERE n.entity_type = 'LIBRARY' and cl.ancestor_id is null
      UNION
      SELECT parent.awln_id, child.awln_id, 1
      FROM ACTION_WORD_LIBRARY_NODE child
      JOIN ACTION_WORD_LIBRARY_NODE parent on child.awl_id = parent.entity_id and parent.entity_type = 'LIBRARY'
      LEFT JOIN AWLN_RELATIONSHIP_CLOSURE cl on child.awln_id = cl.descendant_id and cl.depth = 1
      WHERE child.entity_type = 'ACTION_WORD' and cl.ANCESTOR_ID is null;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-missing-entries-in-awln_relationship_closure', 'jlor', '../tm/tm.changelog-2.00.0.xml', NOW(), 11, '9:658c0bf5e908b86cfdb2dc4bb423afc4', 'sql', 'insert missing entries in awln_relationship_closure: former projects data were not inserted.', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-grant-read-permission-on-projects-to-atw::abo
-- Grant READ permission on projects to automation test writer
insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values (10, 1, 1);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-grant-read-permission-on-projects-to-atw', 'abo', '../tm/tm.changelog-2.00.0.xml', NOW(), 12, '9:15856ddd669af4cee4c5f1d3491fa3ee', 'sql', 'Grant READ permission on projects to automation test writer', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-fix-resource-missing-indexes::jthebault
CREATE INDEX idx_resource_created_by ON RESOURCE(CREATED_BY);

CREATE INDEX idx_resource_last_modified_by ON RESOURCE(LAST_MODIFIED_BY);

CREATE INDEX idx_resource_name ON RESOURCE(NAME);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-fix-resource-missing-indexes', 'jthebault', '../tm/tm.changelog-2.00.0.xml', NOW(), 13, '9:3c688d853dba1dcb939543e4cf53dda5', 'createIndex indexName=idx_resource_created_by, tableName=RESOURCE; createIndex indexName=idx_resource_last_modified_by, tableName=RESOURCE; createIndex indexName=idx_resource_name, tableName=RESOURCE', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-change-item_test_plan_lastexecby-entity-type::jthebault
-- Fix sort on ITEM_TEST_PLAN_LASTEXECBY column - issue 3768
UPDATE QUERY_COLUMN_PROTOTYPE SET ENTITY_TYPE = 'ITEM_TEST_PLAN' WHERE LABEL = 'ITEM_TEST_PLAN_LASTEXECBY';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-change-item_test_plan_lastexecby-entity-type', 'jthebault', '../tm/tm.changelog-2.00.0.xml', NOW(), 14, '9:6407da02c92379595b4a7d252977f11d', 'sql', 'Fix sort on ITEM_TEST_PLAN_LASTEXECBY column - issue 3768', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Changeset ../tm/tm.changelog-2.00.0.xml::tm-2.00.0-add-dataset-name-column-prototype::jthebault
-- Fix sort on ITEM_TEST_PLAN_DATASET_LABEL column - issue 3988
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME, DATA_TYPE, BUSINESS) VALUES
        ('ATTRIBUTE', 'DATASET', NULL, 'DATASET_NAME', 'name', 'STRING', FALSE);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.00.0-add-dataset-name-column-prototype', 'jthebault', '../tm/tm.changelog-2.00.0.xml', NOW(), 15, '9:b24211971b6c22507875f60cca8bbc96', 'sql', 'Fix sort on ITEM_TEST_PLAN_DATASET_LABEL column - issue 3988', 'EXECUTED', NULL, NULL, '4.29.2', '1246608105');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

