/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.actionword.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.KeywordTestStepActionWordParser;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.plugin.premium.actionword.service.utils.MaximumBipartiteMatching;
import org.squashtest.tm.plugin.premium.service.UltimateLicenseChecker;
import org.squashtest.tm.service.actionword.ActionWordService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.display.dto.testcase.ActionWordNameDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.ActionWordDao;
import org.squashtest.tm.service.internal.repository.hibernate.ActionWordSearchDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class ActionWordServiceImpl
implements ActionWordService {
    private final FeatureManager featureManager;
    private final ActionWordSearchDao actionWordSearchDao;
    private final ActionWordDao actionWordDao;
    private final UserAccountService userAccountService;
    private final ProjectFinder projectFinder;
    private final UltimateLicenseChecker ultimateLicenseChecker;

    public ActionWordServiceImpl(FeatureManager featureManager, ActionWordSearchDao actionWordSearchDao, ActionWordDao actionWordDao, UserAccountService userAccountService, ProjectFinder projectFinder, UltimateLicenseChecker ultimateLicenseChecker) {
        this.featureManager = featureManager;
        this.actionWordSearchDao = actionWordSearchDao;
        this.actionWordDao = actionWordDao;
        this.userAccountService = userAccountService;
        this.projectFinder = projectFinder;
        this.ultimateLicenseChecker = ultimateLicenseChecker;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<String> findAllMatchingActionWords(long projectId, String searchInput, List<Long> selectedProjectsIds) {
        this.ultimateLicenseChecker.checkIfAvailable();
        String trimmedWord = searchInput.trim();
        if (trimmedWord.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> searchingTexts = this.getTextsFromString(trimmedWord);
        if (searchingTexts.isEmpty()) {
            return new ArrayList<String>();
        }
        searchingTexts.replaceAll(String::toUpperCase);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List searchableProjectsIds = selectedProjectsIds.isEmpty() ? this.projectFinder.findAllReadableIds(currentUser) : selectedProjectsIds;
        List allActionWords = this.actionWordDao.findByProjectIdOrderByProjectId(searchableProjectsIds);
        Collection<String> allActionWordWords = this.retrieveAllActionWordsFromCurrentProject(allActionWords, projectId);
        allActionWordWords.addAll(this.retrieveAllActionWordsFromOtherProjectsWithoutDuplicates(allActionWords, projectId, allActionWordWords));
        return this.searchMatchedActionWords(searchingTexts, allActionWordWords);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project' , 'READ') or hasRole('ROLE_ADMIN')")
    public Map<String, Long> findAllDuplicatedActionWithProject(long projectId, String word) {
        this.ultimateLicenseChecker.checkIfAvailable();
        String inputToken = this.retrieveTokenFromWord(word);
        return inputToken.isEmpty() ? new HashMap() : this.doFindAllDuplicatedActionWithProject(projectId, inputToken);
    }

    private Map<String, Long> doFindAllDuplicatedActionWithProject(long projectId, String inputToken) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List readableProjectIds = this.projectFinder.findAllReadableIds(currentUser);
        List duplicatedActionWords = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS) ? this.actionWordDao.findByTokenInProjectsIgnoreCase(inputToken, readableProjectIds) : this.actionWordDao.findByTokenInProjects(inputToken, readableProjectIds);
        boolean isCurrentProjectHasDuplicatedAction = duplicatedActionWords.stream().anyMatch(aw -> aw.getProject().getId().equals(projectId));
        if (!isCurrentProjectHasDuplicatedAction && !duplicatedActionWords.isEmpty()) {
            return duplicatedActionWords.stream().collect(Collectors.toMap(aw -> HtmlUtils.htmlEscape((String)aw.getProject().getName()), ActionWord::getId, (aw1, aw2) -> aw1));
        }
        return new HashMap<String, Long>();
    }

    private String retrieveTokenFromWord(String word) {
        String trimmedWord = word.trim();
        if (trimmedWord.isEmpty()) {
            return "";
        }
        KeywordTestStepActionWordParser parser = new KeywordTestStepActionWordParser();
        ActionWord inputActionWord = parser.createActionWordFromKeywordTestStep(trimmedWord);
        return inputActionWord.getToken();
    }

    private Collection<String> retrieveAllActionWordsFromCurrentProject(List<ActionWordNameDto> allActionWords, Long projectId) {
        return allActionWords.stream().filter(a -> a.getProjectId().equals(projectId)).map(ActionWordNameDto::getName).sorted().collect(Collectors.toList());
    }

    private Collection<String> retrieveAllActionWordsFromOtherProjectsWithoutDuplicates(Collection<ActionWordNameDto> allActionWords, Long projectId, Collection<String> allActionWordWords) {
        return allActionWords.stream().filter(a -> !a.getProjectId().equals(projectId)).map(ActionWordNameDto::getName).distinct().filter(a -> !allActionWordWords.contains(a)).sorted().collect(Collectors.toList());
    }

    private Collection<String> searchMatchedActionWords(List<String> searchingTexts, Collection<String> allActionWords) {
        ArrayList<String> result = new ArrayList<String>();
        for (String actionWord : allActionWords) {
            List<String> actionWordTexts = this.getTextsFromString(actionWord);
            actionWordTexts.replaceAll(String::toUpperCase);
            if (!this.matchAllSearchingWords(actionWordTexts, searchingTexts)) continue;
            result.add(actionWord);
        }
        return result;
    }

    private boolean matchAllSearchingWords(List<String> actionWordTextSource, List<String> searchingTexts) {
        boolean[][] bpGraph;
        int actionWordWordsSize;
        int searchingWordsSize = searchingTexts.size();
        MaximumBipartiteMatching matching = new MaximumBipartiteMatching(searchingWordsSize, actionWordWordsSize = actionWordTextSource.size());
        int maximumMatching = matching.maxBPM(bpGraph = this.generateBipartiteGraphForActionWordWordAndSearchingWord(actionWordTextSource, searchingTexts));
        return maximumMatching == searchingWordsSize;
    }

    private boolean[][] generateBipartiteGraphForActionWordWordAndSearchingWord(List<String> actionWordTextSource, List<String> searchingTexts) {
        int searchingWordsSize = searchingTexts.size();
        int actionWordWordsSize = actionWordTextSource.size();
        boolean[][] bpGraph = new boolean[searchingWordsSize][actionWordWordsSize];
        int i = 0;
        while (i < searchingWordsSize) {
            String currentSearchingWord = searchingTexts.get(i);
            int j = 0;
            while (j < actionWordWordsSize) {
                String currentActionWordWord = actionWordTextSource.get(j);
                if (currentActionWordWord.contains(currentSearchingWord)) {
                    bpGraph[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
        return bpGraph;
    }

    private List<String> getTextsFromString(String trimmedWord) {
        String removedFreeValueParams = trimmedWord.replaceAll("\"[^\"]*\"", " ");
        String removedTCValueParams = removedFreeValueParams.replaceAll("<[^\"]*>", " ");
        String[] words = removedTCValueParams.split("(\\s)+");
        LinkedList<String> result = new LinkedList<String>(Arrays.asList(words));
        result.replaceAll(String::trim);
        result.removeIf(word -> word == null || "".equals(word) || ActionWordUtil.isNumber((String)word));
        return result;
    }

    @PreAuthorize(value="hasPermission(#actionWordId, 'org.squashtest.tm.domain.bdd.ActionWord', 'WRITE') or hasRole('ROLE_ADMIN')")
    public String changeDescription(long actionWordId, String newDescription) {
        this.ultimateLicenseChecker.checkIfAvailable();
        ActionWord actionWord = (ActionWord)this.actionWordSearchDao.getReferenceById((Object)actionWordId);
        actionWord.setDescription(newDescription);
        return newDescription;
    }
}

