/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.repository;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.wizard.campaignassistant.internal.repository.WizardDao;

@Repository
public class WizardDaoImpl
implements WizardDao {
    private static final String PLUGIN_ID = "squash.tm.wizard.campaignassistant";
    private static final Map<EntityType, Class> classMap = new HashMap<EntityType, Class>();
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;

    static {
        classMap.put(EntityType.CAMPAIGN_LIBRARY, CampaignLibrary.class);
        classMap.put(EntityType.CAMPAIGN, Campaign.class);
        classMap.put(EntityType.CAMPAIGN_FOLDER, CampaignFolder.class);
        classMap.put(EntityType.ITERATION, Iteration.class);
    }

    @Override
    public List<NamedReference> getIterationsByCampaignId(long campaignId) {
        return this.dslContext.select((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.ITERATION.NAME).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).fetchInto(NamedReference.class);
    }

    @Override
    public <NODE> NODE coerceIntoNode(EntityReference ref) {
        return (NODE)this.entityManager.find(classMap.get(ref.getType()), (Object)ref.getId());
    }

    @Override
    public List<String> findIssues(long iterationId, long serverId) {
        return this.dslContext.selectDistinct((SelectField)Tables.ISSUE.REMOTE_ISSUE_ID).from((TableLike)Tables.ISSUE).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).and(Tables.ISSUE.BUGTRACKER_ID.eq((Object)serverId)).and(Tables.EXECUTION.TCLN_ID.isNotNull()).fetch((Field)Tables.ISSUE.REMOTE_ISSUE_ID, String.class);
    }

    @Override
    public List<Long> findItpisByRemoteIssues(long iterationId, List<String> remoteIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.ISSUE).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.ISSUE.REMOTE_ISSUE_ID.in(remoteIds)).and(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetch((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Long.class);
    }

    @Override
    public boolean isWizardEnabledOnProject(long projectId) {
        return (Integer)this.dslContext.selectCount().from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).leftJoin((TableLike)Project.PROJECT).on(Project.PROJECT.CL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID)).where(Project.PROJECT.PROJECT_ID.equal((Object)projectId).and(Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID.equal((Object)PLUGIN_ID)).and(Tables.LIBRARY_PLUGIN_BINDING.ACTIVE.eq((Object)true))).fetchOne(0, Integer.class) > 0;
    }
}

