/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import jirasync.com.atlassian.jira.rest.client.api.domain.ChangelogItem;
import jirasync.com.atlassian.jira.rest.client.api.domain.FieldType;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class ChangelogItemJsonParser
implements JsonObjectParser<ChangelogItem> {
    @Override
    public ChangelogItem parse(JSONObject json) throws JSONException {
        FieldType fieldType;
        String fieldTypeStr = JsonParseUtil.getNestedString(json, "fieldtype");
        if ("jira".equalsIgnoreCase(fieldTypeStr)) {
            fieldType = FieldType.JIRA;
        } else if ("custom".equalsIgnoreCase(fieldTypeStr)) {
            fieldType = FieldType.CUSTOM;
        } else {
            throw new JSONException("[" + fieldTypeStr + "] does not represent a valid field type. Expected [jira] or [custom].");
        }
        String field = JsonParseUtil.getNestedString(json, "field");
        String from = JsonParseUtil.getNullableString(json, "from");
        String fromString = JsonParseUtil.getNullableString(json, "fromString");
        String to = JsonParseUtil.getNullableString(json, "to");
        String toString = JsonParseUtil.getNullableString(json, "toString");
        return new ChangelogItem(fieldType, field, from, fromString, to, toString);
    }
}

