/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.apache.commons.lang.NullArgumentException;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;
import org.squashtest.tm.service.spi.DefaultOAuth2ConfigurationHandler;
import org.squashtest.tm.service.spi.OAuth2ConfigurationHandler;

@Service(value="squashtest.core.bugtracker.JiraRestConnectorProvider")
public class JiraRestConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    private static final String KIND = "jira.rest";
    private static final String LABEL = "JIRA REST connector";
    @Inject
    private Provider<JiraConnector> connectorProvider;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        JiraConnector connector = (JiraConnector)this.connectorProvider.get();
        connector.init();
        connector.setBugTracker(bugTracker);
        return connector;
    }

    public OAuth2ConfigurationHandler getOAuth2ConfigurationHandler() {
        return new DefaultOAuth2ConfigurationHandler(){

            public DefaultOAuth2FormValues getDefaultValueForOauth2Form(String bugTrackerUrl) {
                return new DefaultOAuth2FormValues(bugTrackerUrl + "/rest/oauth2/latest/authorize", bugTrackerUrl + "/rest/oauth2/latest/token", "WRITE");
            }
        };
    }
}

