/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.plugin.rest.admin.jackson.model.WelcomeMessageDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAdministrationService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.system.SystemAdministrationService;

@Validated
@RestApiController
@UseDefaultRestApiConfiguration
public class RestWelcomeMessageController
extends BaseRestController {
    private final SystemAdministrationService admService;
    private final RestAdministrationService restAdministrationService;

    public RestWelcomeMessageController(SystemAdministrationService admService, RestAdministrationService restAdministrationService) {
        this.admService = admService;
        this.restAdministrationService = restAdministrationService;
    }

    @GetMapping(value={"/welcome-message"})
    @DynamicFilterExpression
    public ResponseEntity<WelcomeMessageDto> getCurrentWelcomeMessage() {
        String welcomeMessage = this.admService.findWelcomeMessage();
        WelcomeMessageDto mess = new WelcomeMessageDto(welcomeMessage);
        return ResponseEntity.ok((Object)mess);
    }

    @PatchMapping(value={"/welcome-message"})
    @DynamicFilterExpression
    public ResponseEntity<WelcomeMessageDto> editWelcomeMessage(@RequestBody WelcomeMessageDto welcomeMessage) {
        String sanitizedMessage = this.restAdministrationService.modifyWelcomeMessage(welcomeMessage.getMessage());
        welcomeMessage.setMessage(sanitizedMessage);
        return ResponseEntity.ok((Object)welcomeMessage);
    }
}

