/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.IssuesQueryBuilderAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValueId;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.Xsquash4GitLabConfigurationException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.AssigneesFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.AuthorFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.EpicFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.FilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.IssueTypeFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.IterationFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.LabelFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.MilestoneFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.StateFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.TitleAndDescriptionFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.WeightFilterBuilderPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.NegatedIssueFilterInput;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.UnionedIssueFilterInput;

public class GitLabIssueQueryFilterBuildersPremium {
    private static final Map<SynchronisationFilterValueId, FilterBuilderPremium> registeredBuilders = new EnumMap<SynchronisationFilterValueId, FilterBuilderPremium>(SynchronisationFilterValueId.class);

    static {
        registeredBuilders.put(SynchronisationFilterValueId.AUTHOR, new AuthorFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.ASSIGNEES, new AssigneesFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.TITLE_AND_DESCRIPTION, new TitleAndDescriptionFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.WEIGHT, new WeightFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.STATE, new StateFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.EPIC, new EpicFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.MILESTONE, new MilestoneFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.LABEL, new LabelFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.ITERATION, new IterationFilterBuilderPremium());
        registeredBuilders.put(SynchronisationFilterValueId.TYPE, new IssueTypeFilterBuilderPremium());
    }

    public static <B> void appendFilters(IssuesQueryBuilderAdapterPremium<B> builder, List<SynchronisationFilterValue> filterValues) {
        NegatedIssueFilterInput.Builder notBuilder = NegatedIssueFilterInput.builder();
        UnionedIssueFilterInput.Builder orBuilder = UnionedIssueFilterInput.builder();
        filterValues.forEach(filterValue -> {
            SynchronisationFilterValueId filterId = GitLabIssueQueryFilterBuildersPremium.getFilterId(filterValue);
            registeredBuilders.get((Object)filterId).appendFilter((SynchronisationFilterValue)filterValue, builder, notBuilder, orBuilder);
        });
        GitLabIssueQueryFilterBuildersPremium.appendNotFilterIfUsed(notBuilder, builder);
        GitLabIssueQueryFilterBuildersPremium.appendOrFilterIfUsed(orBuilder, builder);
    }

    private static <B> void appendNotFilterIfUsed(NegatedIssueFilterInput.Builder notBuilder, IssuesQueryBuilderAdapterPremium<B> parentBuilder) {
        NegatedIssueFilterInput builtInput = notBuilder.build();
        if (GitLabIssueQueryFilterBuildersPremium.isNegatedIssueFilterInputUsed(builtInput)) {
            parentBuilder.not(builtInput);
        }
    }

    private static <B> void appendOrFilterIfUsed(UnionedIssueFilterInput.Builder orBuilder, IssuesQueryBuilderAdapterPremium<B> parentBuilder) {
        UnionedIssueFilterInput builtInput = orBuilder.build();
        if (GitLabIssueQueryFilterBuildersPremium.isUnionedIssueFilterInputUsed(builtInput)) {
            parentBuilder.or(builtInput);
        }
    }

    private static boolean isNegatedIssueFilterInputUsed(NegatedIssueFilterInput builtInput) {
        return Stream.of(new Object[]{builtInput.assigneeId(), builtInput.assigneeUsernames(), builtInput.authorUsername(), builtInput.epicId(), builtInput.iids(), builtInput.iterationId(), builtInput.iterationWildcardId(), builtInput.labelName(), builtInput.milestoneTitle(), builtInput.milestoneWildcardId(), builtInput.myReactionEmoji(), builtInput.releaseTag(), builtInput.types(), builtInput.weight()}).anyMatch(Objects::nonNull);
    }

    private static boolean isUnionedIssueFilterInputUsed(UnionedIssueFilterInput builtInput) {
        return Stream.of(builtInput.authorUsernames(), builtInput.assigneeUsernames(), builtInput.labelNames()).anyMatch(Objects::nonNull);
    }

    private static SynchronisationFilterValueId getFilterId(SynchronisationFilterValue filterValue) {
        SynchronisationFilterValueId filterId = SynchronisationFilterValueId.valueOf(filterValue.getId());
        if (!registeredBuilders.containsKey((Object)filterId)) {
            throw new Xsquash4GitLabConfigurationException("Unhandled filter type " + filterId.name());
        }
        return filterId;
    }

    private GitLabIssueQueryFilterBuildersPremium() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }
}

