/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.MilestoneDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.DateConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupMilestonesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectMilestonesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.MilestoneStateEnum;

public class GitLabMilestoneConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabMilestoneConverter.class);
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public static List<MilestoneDto> convertProjectMilestones(@Nullable GetProjectMilestonesQuery.Data projectMilestonesData) {
        List nodes = Optional.ofNullable(projectMilestonesData).map(GetProjectMilestonesQuery.Data::project).map(GetProjectMilestonesQuery.Project::milestones).map(GetProjectMilestonesQuery.Milestones::nodes).orElse(Collections.emptyList());
        return nodes.stream().map(GitLabMilestoneConverter::convertOneProjectMilestone).collect(Collectors.toList());
    }

    private static MilestoneDto convertOneProjectMilestone(GetProjectMilestonesQuery.Node node) {
        boolean upcoming = GitLabMilestoneConverter.isUpcoming(node.state(), node.expired(), node.startDate());
        return new MilestoneDto(node.id(), node.title(), GitLabMilestoneConverter.retrieveDate(node.startDate()), GitLabMilestoneConverter.retrieveDate(node.dueDate()), node.state(), upcoming, node.expired());
    }

    public static List<MilestoneDto> convertGroupMilestones(@Nullable GetGroupMilestonesQuery.Data groupMilestonesData) {
        List nodes = Optional.ofNullable(groupMilestonesData).map(GetGroupMilestonesQuery.Data::group).map(GetGroupMilestonesQuery.Group::milestones).map(GetGroupMilestonesQuery.Milestones::nodes).orElse(Collections.emptyList());
        return nodes.stream().map(GitLabMilestoneConverter::convertOneGroupMilestone).collect(Collectors.toList());
    }

    private static MilestoneDto convertOneGroupMilestone(GetGroupMilestonesQuery.Node node) {
        boolean upcoming = GitLabMilestoneConverter.isUpcoming(node.state(), node.expired(), node.startDate());
        return new MilestoneDto(node.id(), node.title(), GitLabMilestoneConverter.retrieveDate(node.startDate()), GitLabMilestoneConverter.retrieveDate(node.dueDate()), node.state(), upcoming, node.expired());
    }

    private static boolean isUpcoming(MilestoneStateEnum state, boolean expired, Object gitLabStartDate) {
        if (Objects.isNull(gitLabStartDate)) {
            return false;
        }
        if (!expired && state == MilestoneStateEnum.ACTIVE) {
            try {
                Date startDate = formatter.parse(gitLabStartDate.toString());
                return startDate.after(new Date());
            }
            catch (ParseException e) {
                LOGGER.debug("The date {} could not be parsed", gitLabStartDate, (Object)e);
            }
        }
        return false;
    }

    private GitLabMilestoneConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }

    private static Date retrieveDate(Object date) {
        return date != null ? DateConverter.parseDate(date.toString()) : null;
    }
}

