/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabUserDto;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupMembersQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectMembersQuery;

public class GitLabMemberConverter {
    public static List<GitLabUserDto> convertProjectGitLabUsers(@Nullable GetProjectMembersQuery.Data projectMembersData) {
        List nodes = Optional.ofNullable(projectMembersData).map(GetProjectMembersQuery.Data::project).map(GetProjectMembersQuery.Project::projectMembers).map(GetProjectMembersQuery.ProjectMembers::nodes).orElse(Collections.emptyList());
        return nodes.stream().map(GitLabMemberConverter::convertOneProjectMember).filter(gitLabUserDto -> gitLabUserDto != null).collect(Collectors.toList());
    }

    private static GitLabUserDto convertOneProjectMember(GetProjectMembersQuery.Node node) {
        if (node.id() == null) {
            throw new IllegalArgumentException("Received malformed project members data.");
        }
        GetProjectMembersQuery.User user = node.user();
        if (user == null) {
            return null;
        }
        return new GitLabUserDto(user.username(), GitLabMemberConverter.getDisplayedName(user.name(), user.username()));
    }

    public static List<GitLabUserDto> convertGroupGitLabUsers(@Nullable GetGroupMembersQuery.Data data) {
        return Optional.ofNullable(data).map(GetGroupMembersQuery.Data::group).map(GetGroupMembersQuery.Group::groupMembers).map(GetGroupMembersQuery.GroupMembers::nodes).orElse(Collections.emptyList()).stream().map(GitLabMemberConverter::convertOneGroupMember).filter(gitLabUserDto -> gitLabUserDto != null).collect(Collectors.toList());
    }

    private static GitLabUserDto convertOneGroupMember(GetGroupMembersQuery.Node node) {
        if (node.id() == null) {
            throw new IllegalArgumentException("Received malformed group members data.");
        }
        GetGroupMembersQuery.User user = node.user();
        if (user == null) {
            return null;
        }
        return new GitLabUserDto(user.username(), GitLabMemberConverter.getDisplayedName(user.name(), user.username()));
    }

    private static String getDisplayedName(String name, String username) {
        return String.format("%s (%s)", name, username);
    }

    private GitLabMemberConverter() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }
}

