/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.squashtest.tm.domain.helper.EmojiStringHelper;

public class Mappings {
    private Labels categoryLabels;
    private Labels criticalityLabels;
    private Labels statusLabels;

    public Mappings(Labels categoryLabels, Labels criticalityLabels, Labels statusLabels) {
        this.categoryLabels = categoryLabels;
        this.criticalityLabels = criticalityLabels;
        this.statusLabels = statusLabels;
    }

    public Mappings() {
        this.categoryLabels = new Labels();
        this.criticalityLabels = new Labels();
        this.statusLabels = new Labels();
    }

    public static Mappings empty() {
        return new Mappings(new Labels(), new Labels(), new Labels());
    }

    public static Mappings getCleanedMappings(Mappings mappings) {
        if (!Objects.isNull(mappings)) {
            mappings.categoryLabels = Mappings.getCleanedLabels(mappings.categoryLabels);
            mappings.criticalityLabels = Mappings.getCleanedLabels(mappings.criticalityLabels);
            mappings.statusLabels = Mappings.getCleanedLabels(mappings.statusLabels);
            return mappings;
        }
        return Mappings.empty();
    }

    private static Labels getCleanedLabels(Labels labels) {
        List scopeLabels = Objects.isNull(labels) ? Collections.emptyList() : EmojiStringHelper.findAndEncodeStringsWithEmoji(labels.getScopeLabels());
        List noScopeLabels = Objects.isNull(labels) ? Collections.emptyList() : EmojiStringHelper.findAndEncodeStringsWithEmoji(labels.getNoScopeLabels());
        return new Labels(scopeLabels, noScopeLabels);
    }

    public Labels getCategoryLabels() {
        return this.categoryLabels;
    }

    public Labels getCriticalityLabels() {
        return this.criticalityLabels;
    }

    public Labels getStatusLabels() {
        return this.statusLabels;
    }

    public static boolean isEmptyOrNull(Mappings mappings) {
        if (Objects.isNull(mappings)) {
            return true;
        }
        Labels categoryLabels = Mappings.getCleanedLabels(mappings.getCategoryLabels());
        Labels criticalityLabels = Mappings.getCleanedLabels(mappings.getCriticalityLabels());
        Labels statusLabels = Mappings.getCleanedLabels(mappings.getStatusLabels());
        List<List> allLabels = Arrays.asList(categoryLabels.getNoScopeLabels(), categoryLabels.getScopeLabels(), criticalityLabels.getNoScopeLabels(), criticalityLabels.getScopeLabels(), statusLabels.getNoScopeLabels(), statusLabels.getScopeLabels());
        return allLabels.stream().allMatch(List::isEmpty);
    }

    public static final class Labels {
        public static final String SCOPE_LABEL_SEPARATOR = "::";
        private List<String> scopeLabels = Collections.emptyList();
        private List<String> noScopeLabels = Collections.emptyList();

        public Labels() {
        }

        public Labels(List<String> scopeLabels, List<String> noScopeLabels) {
            this.scopeLabels = scopeLabels;
            this.noScopeLabels = noScopeLabels;
        }

        public static Labels empty() {
            return new Labels(new ArrayList<String>(), new ArrayList<String>());
        }

        public static Labels createLabelsFromList(List<String> labels) {
            if (Objects.isNull(labels)) {
                return Labels.empty();
            }
            HashSet scopeLabels = new HashSet();
            HashSet noScopeLabels = new HashSet();
            labels.forEach(label -> {
                String[] parts = label.split(SCOPE_LABEL_SEPARATOR);
                if (parts.length > 1) {
                    String scopeLabel = String.join((CharSequence)SCOPE_LABEL_SEPARATOR, Arrays.copyOf(parts, parts.length - 1));
                    scopeLabels.add(scopeLabel);
                } else {
                    noScopeLabels.add(label);
                }
            });
            return new Labels(new ArrayList<String>(scopeLabels), new ArrayList<String>(noScopeLabels));
        }

        public static Map<String, String> getScopeValuesByKeysFromList(List<String> labels) {
            HashMap<String, String> scopeValuesByKeys = new HashMap<String, String>();
            if (labels != null) {
                labels.forEach(label -> {
                    String[] parts = label.split(SCOPE_LABEL_SEPARATOR);
                    if (parts.length > 1) {
                        String key = String.join((CharSequence)SCOPE_LABEL_SEPARATOR, Arrays.copyOf(parts, parts.length - 1));
                        String value = parts[parts.length - 1];
                        scopeValuesByKeys.put(key, value);
                    }
                });
            }
            return scopeValuesByKeys;
        }

        public static List<String> getOnlyNoScopeLabelsFromList(List<String> labels) {
            if (Objects.isNull(labels)) {
                return new ArrayList<String>();
            }
            ArrayList<String> noScopeLabels = new ArrayList<String>();
            labels.forEach(label -> {
                if (!label.contains(SCOPE_LABEL_SEPARATOR)) {
                    noScopeLabels.add((String)label);
                }
            });
            return noScopeLabels;
        }

        public List<String> getScopeLabels() {
            return this.scopeLabels;
        }

        public List<String> getNoScopeLabels() {
            return this.noScopeLabels;
        }
    }
}

