/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.json;

import java.util.Collections;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.SearchResult;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import workflowautomjira.org.codehaus.jettison.json.JSONArray;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

public class SearchResultJsonParser
implements JsonObjectParser<SearchResult> {
    private static final int DEFAULT_MAX_RESULTS = 50;

    @Override
    public SearchResult parse(JSONObject json) throws JSONException {
        Iterable<Issue> issues;
        String nextPageToken = null;
        int startAt = 0;
        if (json.has("nextPageToken")) {
            nextPageToken = json.optString("nextPageToken", null);
        }
        if (json.has("startAt")) {
            startAt = json.optInt("startAt", 0);
        }
        int maxResults = json.has("maxResults") ? json.optInt("maxResults", 50) : 50;
        int total = json.has("total") ? json.optInt("total", 0) : 0;
        JSONArray issuesJsonArray = json.getJSONArray("issues");
        if (issuesJsonArray.length() > 0) {
            IssueJsonParser issueParser = new IssueJsonParser(json.optJSONObject("names"), json.optJSONObject("schema"));
            GenericJsonArrayParser<Issue> issuesParser = GenericJsonArrayParser.create(issueParser);
            issues = issuesParser.parse(issuesJsonArray);
        } else {
            issues = Collections.emptyList();
        }
        return new SearchResult(startAt, nextPageToken, maxResults, total, issues);
    }
}

