/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jiracloud.com.atlassian.httpclient.api.HttpClient;
import jiracloud.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jiracloud.com.atlassian.jira.rest.client.api.JiraRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import jiracloud.com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;

public class AsynchronousJiraRestClientFactory
implements JiraRestClientFactory {
    @Override
    public JiraRestClient create(URI serverUri, AuthenticationHandler authenticationHandler) {
        DisposableHttpClient httpClient = new AsynchronousHttpClientFactory().createClient(serverUri, authenticationHandler);
        return new AsynchronousJiraRestClient(serverUri, httpClient);
    }

    @Override
    public JiraRestClient createWithBasicHttpAuthentication(URI serverUri, String username, String password) {
        return this.create(serverUri, new BasicHttpAuthenticationHandler(username, password));
    }

    @Override
    public JiraRestClient createWithAuthenticationHandler(URI serverUri, AuthenticationHandler authenticationHandler) {
        return this.create(serverUri, authenticationHandler);
    }

    @Override
    public JiraRestClient create(URI serverUri, HttpClient httpClient) {
        DisposableHttpClient disposableHttpClient = new AsynchronousHttpClientFactory().createClient(httpClient);
        return new AsynchronousJiraRestClient(serverUri, disposableHttpClient);
    }
}

