/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.actionword.ActionWordFragmentVisitor;
import org.squashtest.tm.domain.actionword.ConsumerForActionWordFragmentVisitor;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.testcase.KeywordTestStep;

@Component
public class KeywordTestStepActionPropertyWriter
extends VirtualBeanPropertyWriter {
    private static final String ESCAPED_BACKSLASH = "\"";

    public KeywordTestStepActionPropertyWriter() {
    }

    private KeywordTestStepActionPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        KeywordTestStep holder = (KeywordTestStep)bean;
        ActionWord actionWord = holder.getActionWord();
        List fragments = actionWord.getFragments();
        List paramValues = holder.getParamValues();
        return this.createWord(fragments, paramValues);
    }

    private String createWord(List<ActionWordFragment> fragments, List<ActionWordParameterValue> paramValues) {
        StringBuilder builder = new StringBuilder();
        Consumer<ActionWordParameter> consumer = parameter -> this.appendParamValueToCreateWord((ActionWordParameter)parameter, paramValues, builder);
        ConsumerForActionWordFragmentVisitor visitor = new ConsumerForActionWordFragmentVisitor(consumer, builder);
        for (ActionWordFragment fragment : fragments) {
            fragment.accept((ActionWordFragmentVisitor)visitor);
        }
        return builder.toString();
    }

    private void appendParamValueToCreateWord(ActionWordParameter param, List<ActionWordParameterValue> paramValues, StringBuilder builder) {
        Optional<ActionWordParameterValue> paramValue = paramValues.stream().filter(pv -> pv.getActionWordParam() != null && pv.getActionWordParam().getId().equals(param.getId())).findAny();
        paramValue.ifPresent(actionWordParameterValue -> {
            if (actionWordParameterValue.isLinkedToTestCaseParam()) {
                builder.append(actionWordParameterValue.getValue());
            } else {
                builder.append(ESCAPED_BACKSLASH).append(actionWordParameterValue.getValue()).append(ESCAPED_BACKSLASH);
            }
        });
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new KeywordTestStepActionPropertyWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

