/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean;

import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3FieldInfo;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3FieldSchema;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3StandardOperation;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.CollectionUtils;

public class ExtendedTracker
extends Tracker {
    private static final String TRACKER = "Tracker";
    private static final String ATTACHMENT = "attachment";
    private static final String DESCRIPTION = "description";
    private static final String CUSTOM_FIELD_PREFIX = "redmine.custom.";
    private static final List<String> REQUIRED_CORE_FIELDS = Arrays.asList("subject", "priority", "description");
    private static final List<String> DONE_RATIO_VALUES = Arrays.asList("0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100");
    private static final long serialVersionUID = 1L;
    private static final String CUSTOM_FIELD_MULTIPLE = "multiple";
    private static final String DONE_RATIO = "done_ratio";
    private static final String CATEGORY = "category_id";
    private static final String VERSION = "fixed_version_id";
    private static final String STATUS_OPEN = "open";
    private List<String> coreFields;
    private transient List<ExtendedCustomField> customFields;

    public List<String> getCoreFields() {
        return CollectionUtils.unModifiableList(this.coreFields);
    }

    public void setCoreFields(List<String> coreFields) {
        this.coreFields = coreFields;
    }

    public List<ExtendedCustomField> getCustomFields() {
        return CollectionUtils.unModifiableList(this.customFields);
    }

    public void setCustomFields(List<ExtendedCustomField> customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "ExtendedTracker [core_fields=" + String.valueOf(this.coreFields) + ", custom_fields=" + String.valueOf(this.customFields) + ", getId()=" + String.valueOf(this.getId()) + ", getName()=" + this.getName() + "]";
    }

    public Map<String, Redmine3FieldInfo> getFields(Project redmineProject) {
        LinkedHashMap<String, Redmine3FieldInfo> result = new LinkedHashMap<String, Redmine3FieldInfo>();
        this.createTrackerField(result);
        this.createAttachementField(result);
        this.createRequiredCoreFields(result, redmineProject);
        this.createOptionalCoreFields(result, redmineProject);
        this.createCustomFields(result, redmineProject);
        return result;
    }

    private void createTrackerField(Map<String, Redmine3FieldInfo> result) {
        HashSet<Redmine3StandardOperation> operations = new HashSet<Redmine3StandardOperation>();
        operations.add(Redmine3StandardOperation.SET);
        Redmine3FieldSchema trackerFieldSchema = new Redmine3FieldSchema(null, null, TRACKER, null, null);
        Redmine3FieldInfo trackerFieldInfo = new Redmine3FieldInfo(TRACKER, true, TRACKER, operations, trackerFieldSchema, null);
        result.put(TRACKER, trackerFieldInfo);
    }

    private void createAttachementField(Map<String, Redmine3FieldInfo> result) {
        HashSet<Redmine3StandardOperation> operationAttach = new HashSet<Redmine3StandardOperation>();
        Redmine3FieldSchema attachmentFieldSchema = new Redmine3FieldSchema("array", ATTACHMENT, ATTACHMENT, null, null);
        Redmine3FieldInfo attachmentFieldInfo = new Redmine3FieldInfo(ATTACHMENT, false, ATTACHMENT, operationAttach, attachmentFieldSchema, null);
        result.put(ATTACHMENT, attachmentFieldInfo);
    }

    private void createRequiredCoreFields(Map<String, Redmine3FieldInfo> result, Project redmineProject) {
        HashSet<Redmine3StandardOperation> operations = new HashSet<Redmine3StandardOperation>();
        operations.add(Redmine3StandardOperation.SET);
        for (String requiredCoreField : REQUIRED_CORE_FIELDS) {
            ArrayList<Object> possibleValues = null;
            String type = null;
            if ("priority".equals(requiredCoreField)) {
                possibleValues = new ArrayList<Object>(((ExtendedProject)redmineProject).getPriority());
                type = requiredCoreField;
            }
            this.createCoreFieldInfo(result, requiredCoreField, operations, type, true, possibleValues);
        }
    }

    private void createOptionalCoreFields(Map<String, Redmine3FieldInfo> result, Project redmineProject) {
        HashSet<Redmine3StandardOperation> operations = new HashSet<Redmine3StandardOperation>();
        operations.add(Redmine3StandardOperation.SET);
        List<String> optionalFields = this.getCoreFields();
        for (String coreField : optionalFields) {
            if (coreField.equals(DESCRIPTION)) continue;
            List<Object> possibleValues = null;
            String type = coreField;
            if (DONE_RATIO.equals(coreField)) {
                possibleValues = new ArrayList<String>(DONE_RATIO_VALUES);
            } else if (CATEGORY.equals(coreField)) {
                possibleValues = new ArrayList<IssueCategory>(((ExtendedProject)redmineProject).getCategory());
            } else if (VERSION.equals(coreField)) {
                ArrayList<Version> possibleVersions = new ArrayList<Version>(((ExtendedProject)redmineProject).getVersions());
                possibleValues = possibleVersions.stream().filter(version -> STATUS_OPEN.equals(version.getStatus())).collect(Collectors.toUnmodifiableList());
            }
            this.createCoreFieldInfo(result, coreField, operations, type, false, possibleValues);
        }
    }

    private void createCustomFields(Map<String, Redmine3FieldInfo> result, Project redmineProject) {
        HashSet<Redmine3StandardOperation> operations = new HashSet<Redmine3StandardOperation>();
        operations.add(Redmine3StandardOperation.SET);
        for (ExtendedCustomField customField : this.getCustomFields()) {
            if (!customField.isAvailableForProject(redmineProject)) continue;
            List<Object> possibleValues = this.getPossibleValuesForCustomField(customField, redmineProject);
            this.createCustomField(result, customField, operations, possibleValues);
        }
    }

    private List<Object> getPossibleValuesForCustomField(ExtendedCustomField customField, Project redmineProject) {
        ArrayList<Object> possibleValues = null;
        String customType = customField.getFieldFormat();
        if ("list".equals(customType)) {
            possibleValues = new ArrayList<Object>(customField.getPossibleValues());
        } else if ("user".equals(customType)) {
            possibleValues = new ArrayList<User>(((ExtendedProject)redmineProject).getUsers());
        } else if ("version".equals(customType)) {
            possibleValues = new ArrayList<Version>(((ExtendedProject)redmineProject).getVersions());
        } else if ("bool".equals(customType)) {
            ArrayList<Boolean> bools = new ArrayList<Boolean>();
            bools.add(Boolean.FALSE);
            bools.add(Boolean.TRUE);
            possibleValues = new ArrayList(bools);
        }
        return possibleValues;
    }

    private void createCustomField(Map<String, Redmine3FieldInfo> result, ExtendedCustomField customField, Set<Redmine3StandardOperation> operations, Iterable<Object> allowedValues) {
        Object custom = CUSTOM_FIELD_PREFIX + customField.getFieldFormat();
        if (customField.isMultiple()) {
            custom = "redmine.custom.multiple";
        }
        Redmine3FieldSchema fieldSchema = new Redmine3FieldSchema(CUSTOM_FIELD_PREFIX + customField.getFieldFormat(), null, null, (String)custom, Long.valueOf(customField.getId()));
        Redmine3FieldInfo fieldInfo = new Redmine3FieldInfo(customField.getName(), customField.isRequired(), customField.getName(), operations, fieldSchema, allowedValues);
        result.put(customField.getName(), fieldInfo);
    }

    private void createCoreFieldInfo(Map<String, Redmine3FieldInfo> result, String name, Set<Redmine3StandardOperation> operations, String type, boolean required, Iterable<Object> allowedValues) {
        Redmine3FieldSchema fieldSchema = new Redmine3FieldSchema(type, null, name, null, null);
        Redmine3FieldInfo fieldInfo = new Redmine3FieldInfo(name, required, name, operations, fieldSchema, allowedValues);
        result.put(name, fieldInfo);
    }
}

