/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpHost;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.ClientProtocolException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.config.RequestConfig;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.CloseableHttpResponse;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.Configurable;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.HttpExecutionAware;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.HttpRequestWrapper;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.protocol.HttpClientContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.ClientConnectionManager;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.ClientConnectionRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.HttpClientConnectionManager;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.ManagedClientConnection;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.routing.HttpRoute;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.conn.scheme.SchemeRegistry;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.DefaultConnectionReuseStrategy;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.execchain.MinimalClientExec;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.params.BasicHttpParams;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.params.HttpParams;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.BasicHttpContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpRequestExecutor;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

