/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.controller;

import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.plugin.bugtracker.gitlab.dto.ConfigPageModelDto;
import org.squashtest.tm.plugin.bugtracker.gitlab.service.ConfigurationService;

@RestController(value="squash.tm.plugin.bugtracker.gitlab.ConfigurationController")
@RequestMapping(value={"backend/plugin/gitlab-bugtracker/configuration/project/{projectId}"})
public class ConfigurationController {
    private final ConfigurationService configurationService;

    public ConfigurationController(@Named(value="squash.tm.plugin.bugtracker.gitlab.ConfigurationService") ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @GetMapping
    public ConfigPageModelDto getConfigurationPageData(@PathVariable(value="projectId") Long projectId) {
        return this.configurationService.getConfigurationPageData(projectId);
    }

    @PostMapping(value={"priority-mappings"})
    public void setPriorityMappings(@PathVariable(value="projectId") Long projectId, @RequestBody ChangeMappingsRequestBody requestBody) {
        this.configurationService.setPriorityMappings(projectId, requestBody.projectPath, requestBody.scopes, requestBody.labels);
    }

    @PostMapping(value={"status-mappings"})
    public void setStatusMappings(@PathVariable(value="projectId") Long projectId, @RequestBody ChangeMappingsRequestBody requestBody) {
        this.configurationService.setStatusMappings(projectId, requestBody.projectPath, requestBody.scopes, requestBody.labels);
    }

    @PostMapping(value={"custom-description-template"})
    public void setCustomDescriptionTemplate(@PathVariable(value="projectId") Long projectId, @RequestBody ChangeDescriptionTemplateRequestBody requestBody) {
        this.configurationService.setCustomDescriptionTemplate(projectId, requestBody.projectPath, requestBody.customDescriptionTemplate);
    }

    @PostMapping(value={"remove-configuration"})
    public void removeMappings(@PathVariable(value="projectId") Long projectId, @RequestBody RemoveMappingsRequestBody requestBody) {
        this.configurationService.removeProjectMappings(projectId, requestBody.projectPath);
    }

    @PostMapping(value={"display-state"})
    public void update(@PathVariable(value="projectId") long projectId, @RequestBody Map<String, Boolean> newValue) {
        this.configurationService.updateDisplayState(projectId, newValue.get("newValue"));
    }

    static final class ChangeMappingsRequestBody {
        String projectPath;
        List<String> scopes;
        List<String> labels;

        ChangeMappingsRequestBody() {
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public List<String> getLabels() {
            return this.labels;
        }
    }

    public record ChangeDescriptionTemplateRequestBody(String projectPath, String customDescriptionTemplate) {
    }

    private static final class RemoveMappingsRequestBody {
        String projectPath;

        RemoveMappingsRequestBody() {
        }

        public String getProjectPath() {
            return this.projectPath;
        }
    }
}

