/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api.models;

import gitlabbt.com.fasterxml.jackson.annotation.JsonCreator;
import gitlabbt.com.fasterxml.jackson.annotation.JsonIgnore;
import gitlabbt.com.fasterxml.jackson.annotation.JsonProperty;
import gitlabbt.com.fasterxml.jackson.annotation.JsonValue;
import gitlabbt.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gitlabbt.org.gitlab4j.api.models.ContainerExpirationPolicy;
import gitlabbt.org.gitlab4j.api.models.CustomAttribute;
import gitlabbt.org.gitlab4j.api.models.ImportStatus;
import gitlabbt.org.gitlab4j.api.models.Namespace;
import gitlabbt.org.gitlab4j.api.models.Owner;
import gitlabbt.org.gitlab4j.api.models.Permissions;
import gitlabbt.org.gitlab4j.api.models.ProjectLicense;
import gitlabbt.org.gitlab4j.api.models.ProjectStatistics;
import gitlabbt.org.gitlab4j.api.models.SharedGroup;
import gitlabbt.org.gitlab4j.api.models.Visibility;
import gitlabbt.org.gitlab4j.models.Constants;
import gitlabbt.org.gitlab4j.models.utils.JacksonJson;
import gitlabbt.org.gitlab4j.models.utils.JacksonJsonEnumHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Project
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer approvalsBeforeMerge;
    private Boolean archived;
    private String avatarUrl;
    private Boolean containerRegistryEnabled;
    private Date createdAt;
    private Long creatorId;
    private String defaultBranch;
    private String description;
    private Integer forksCount;
    private Project forkedFromProject;
    private String httpUrlToRepo;
    private Long id;
    private Boolean isPublic;
    private Boolean issuesEnabled;
    private Boolean jobsEnabled;
    private Date lastActivityAt;
    private Boolean lfsEnabled;
    private MergeMethod mergeMethod;
    private Boolean mergeRequestsEnabled;
    private String name;
    private Namespace namespace;
    private String nameWithNamespace;
    private Boolean onlyAllowMergeIfPipelineSucceeds;
    private Boolean allowMergeOnSkippedPipeline;
    private Boolean onlyAllowMergeIfAllDiscussionsAreResolved;
    private Integer openIssuesCount;
    private Owner owner;
    private String path;
    private String pathWithNamespace;
    private Permissions permissions;
    private Boolean publicJobs;
    private String repositoryStorage;
    private Boolean requestAccessEnabled;
    private String runnersToken;
    private Boolean sharedRunnersEnabled;
    private List<SharedGroup> sharedWithGroups;
    private Boolean snippetsEnabled;
    private String sshUrlToRepo;
    private Integer starCount;
    private List<String> tagList;
    private List<String> topics;
    private Integer visibilityLevel;
    private Visibility visibility;
    private Boolean wallEnabled;
    private String webUrl;
    private Boolean wikiEnabled;
    private Boolean printingMergeRequestLinkEnabled;
    private Boolean resolveOutdatedDiffDiscussions;
    private ProjectStatistics statistics;
    private Boolean initializeWithReadme;
    private Boolean packagesEnabled;
    private Boolean emptyRepo;
    private String licenseUrl;
    private ProjectLicense license;
    private List<CustomAttribute> customAttributes;
    private String buildCoverageRegex;
    private Constants.BuildGitStrategy buildGitStrategy;
    private String readmeUrl;
    private Boolean canCreateMergeRequestIn;
    private ImportStatus.Status importStatus;
    private Integer ciDefaultGitDepth;
    private Boolean ciForwardDeploymentEnabled;
    private String ciConfigPath;
    private Boolean removeSourceBranchAfterMerge;
    private Boolean autoDevopsEnabled;
    private Constants.AutoDevopsDeployStrategy autoDevopsDeployStrategy;
    private Boolean autocloseReferencedIssues;
    private Boolean emailsDisabled;
    private String suggestionCommitMessage;
    private Constants.SquashOption squashOption;
    private String mergeCommitTemplate;
    private String squashCommitTemplate;
    private String issueBranchTemplate;
    private String mergeRequestsTemplate;
    private String issuesTemplate;
    private Boolean useCustomTemplate;
    private String externalAuthorizationClassificationLabel;
    private Boolean groupRunnersEnabled;
    private Boolean showDefaultAwardEmojis;
    private Boolean warnAboutPotentiallyUnwantedCharacters;
    private Boolean mirrorTriggerBuilds;
    private Constants.AutoCancelPendingPipelines autoCancelPendingPipelines;
    private String repositoryObjectFormat;
    private Boolean onlyAllowMergeIfAllStatusChecksPassed;
    private Integer groupWithProjectTemplatesId;
    private Boolean publicBuilds;
    private Integer buildTimeout;
    private String templateName;
    private Boolean emailsEnabled;
    private Boolean mirror;
    private Date updatedAt;
    private String descriptionHtml;
    private String containerRegistryImagePrefix;
    private ContainerExpirationPolicy containerExpirationPolicy;
    private Boolean serviceDeskEnabled;
    private String importUrl;
    private String importType;
    private String importError;
    private Boolean ciForwardDeploymentRollbackAllowed;
    private Boolean ciAllowForkPipelinesToRunInParentProject;
    private List<String> ciIdTokenSubClaimComponents;
    private Boolean ciJobTokenScopeEnabled;
    private Boolean ciSeparatedCaches;
    private String ciRestrictPipelineCancellationRole;
    private String ciPipelineVariablesMinimumOverrideRole;
    private Boolean ciPushRepositoryForJobTokenAllowed;
    private Boolean allowPipelineTriggerApproveDeployment;
    private Boolean restrictUserDefinedVariables;
    private Boolean enforceAuthChecksOnUploads;
    private Boolean keepLatestArtifact;
    private Integer runnerTokenExpirationInterval;
    private Boolean requirementsEnabled;
    private Boolean securityAndComplianceEnabled;
    private Boolean secretPushProtectionEnabled;
    private List<String> complianceFrameworks;
    private Constants.ProjectFeatureVisibilityAccessLevel analyticsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel buildsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel containerRegistryAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel environmentsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel featureFlagsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel forkingAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel infrastructureAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel issuesAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel mergeRequestsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel modelExperimentsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel modelRegistryAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel monitorAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel pagesAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel releasesAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel repositoryAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel requirementsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel securityAndComplianceAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel snippetsAccessLevel;
    private Constants.ProjectFeatureVisibilityAccessLevel wikiAccessLevel;
    @JsonProperty(value="_links")
    private Map<String, String> links;
    @JsonSerialize(using=JacksonJson.DateOnlySerializer.class)
    private Date markedForDeletionOn;

    public Integer getApprovalsBeforeMerge() {
        return this.approvalsBeforeMerge;
    }

    public void setApprovalsBeforeMerge(Integer approvalsBeforeMerge) {
        this.approvalsBeforeMerge = approvalsBeforeMerge;
    }

    public Project withApprovalsBeforeMerge(Integer approvalsBeforeMerge) {
        this.approvalsBeforeMerge = approvalsBeforeMerge;
        return this;
    }

    public Boolean getArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Boolean getContainerRegistryEnabled() {
        return this.containerRegistryEnabled;
    }

    public void setContainerRegistryEnabled(Boolean containerRegistryEnabled) {
        this.containerRegistryEnabled = containerRegistryEnabled;
    }

    public Project withContainerRegistryEnabled(Boolean containerRegistryEnabled) {
        this.containerRegistryEnabled = containerRegistryEnabled;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public Project withDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Project withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer getForksCount() {
        return this.forksCount;
    }

    public void setForksCount(Integer forksCount) {
        this.forksCount = forksCount;
    }

    public Project getForkedFromProject() {
        return this.forkedFromProject;
    }

    public void setForkedFromProject(Project forkedFromProject) {
        this.forkedFromProject = forkedFromProject;
    }

    public String getHttpUrlToRepo() {
        return this.httpUrlToRepo;
    }

    public void setHttpUrlToRepo(String httpUrlToRepo) {
        this.httpUrlToRepo = httpUrlToRepo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Project withId(Long id) {
        this.id = id;
        return this;
    }

    public Boolean getIssuesEnabled() {
        return this.issuesEnabled;
    }

    public void setIssuesEnabled(Boolean issuesEnabled) {
        this.issuesEnabled = issuesEnabled;
    }

    public Project withIssuesEnabled(Boolean issuesEnabled) {
        this.issuesEnabled = issuesEnabled;
        return this;
    }

    public Boolean getJobsEnabled() {
        return this.jobsEnabled;
    }

    public void setJobsEnabled(Boolean jobsEnabled) {
        this.jobsEnabled = jobsEnabled;
    }

    public Project withJobsEnabled(Boolean jobsEnabled) {
        this.jobsEnabled = jobsEnabled;
        return this;
    }

    public Date getLastActivityAt() {
        return this.lastActivityAt;
    }

    public void setLastActivityAt(Date lastActivityAt) {
        this.lastActivityAt = lastActivityAt;
    }

    public Boolean getLfsEnabled() {
        return this.lfsEnabled;
    }

    public void setLfsEnabled(Boolean lfsEnabled) {
        this.lfsEnabled = lfsEnabled;
    }

    public Project withLfsEnabled(Boolean lfsEnabled) {
        this.lfsEnabled = lfsEnabled;
        return this;
    }

    public MergeMethod getMergeMethod() {
        return this.mergeMethod;
    }

    public void setMergeMethod(MergeMethod mergeMethod) {
        this.mergeMethod = mergeMethod;
    }

    public Project withMergeMethod(MergeMethod mergeMethod) {
        this.mergeMethod = mergeMethod;
        return this;
    }

    public Boolean getMergeRequestsEnabled() {
        return this.mergeRequestsEnabled;
    }

    public void setMergeRequestsEnabled(Boolean mergeRequestsEnabled) {
        this.mergeRequestsEnabled = mergeRequestsEnabled;
    }

    public Project withMergeRequestsEnabled(Boolean mergeRequestsEnabled) {
        this.mergeRequestsEnabled = mergeRequestsEnabled;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project withName(String name) {
        this.name = name;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public Project withNamespace(Namespace namespace) {
        this.namespace = namespace;
        return this;
    }

    public Project withNamespaceId(long namespaceId) {
        this.namespace = new Namespace();
        this.namespace.setId(namespaceId);
        return this;
    }

    public String getNameWithNamespace() {
        return this.nameWithNamespace;
    }

    public void setNameWithNamespace(String nameWithNamespace) {
        this.nameWithNamespace = nameWithNamespace;
    }

    public Boolean getOnlyAllowMergeIfPipelineSucceeds() {
        return this.onlyAllowMergeIfPipelineSucceeds;
    }

    public void setOnlyAllowMergeIfPipelineSucceeds(Boolean onlyAllowMergeIfPipelineSucceeds) {
        this.onlyAllowMergeIfPipelineSucceeds = onlyAllowMergeIfPipelineSucceeds;
    }

    public Project withOnlyAllowMergeIfPipelineSucceeds(Boolean onlyAllowMergeIfPipelineSucceeds) {
        this.onlyAllowMergeIfPipelineSucceeds = onlyAllowMergeIfPipelineSucceeds;
        return this;
    }

    public Boolean getAllowMergeOnSkippedPipeline() {
        return this.allowMergeOnSkippedPipeline;
    }

    public void setAllowMergeOnSkippedPipeline(Boolean allowMergeOnSkippedPipeline) {
        this.allowMergeOnSkippedPipeline = allowMergeOnSkippedPipeline;
    }

    public Project withAllowMergeOnSkippedPipeline(Boolean allowMergeOnSkippedPipeline) {
        this.allowMergeOnSkippedPipeline = allowMergeOnSkippedPipeline;
        return this;
    }

    public Boolean getOnlyAllowMergeIfAllDiscussionsAreResolved() {
        return this.onlyAllowMergeIfAllDiscussionsAreResolved;
    }

    public void setOnlyAllowMergeIfAllDiscussionsAreResolved(Boolean onlyAllowMergeIfAllDiscussionsAreResolved) {
        this.onlyAllowMergeIfAllDiscussionsAreResolved = onlyAllowMergeIfAllDiscussionsAreResolved;
    }

    public Project withOnlyAllowMergeIfAllDiscussionsAreResolved(Boolean onlyAllowMergeIfAllDiscussionsAreResolved) {
        this.onlyAllowMergeIfAllDiscussionsAreResolved = onlyAllowMergeIfAllDiscussionsAreResolved;
        return this;
    }

    public Integer getOpenIssuesCount() {
        return this.openIssuesCount;
    }

    public void setOpenIssuesCount(Integer openIssuesCount) {
        this.openIssuesCount = openIssuesCount;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Project withPath(String path) {
        this.path = path;
        return this;
    }

    public String getPathWithNamespace() {
        return this.pathWithNamespace;
    }

    public void setPathWithNamespace(String pathWithNamespace) {
        this.pathWithNamespace = pathWithNamespace;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public Project withPublic(Boolean isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    public Boolean getPublicJobs() {
        return this.publicJobs;
    }

    public void setPublicJobs(Boolean publicJobs) {
        this.publicJobs = publicJobs;
    }

    public Project withPublicJobs(Boolean publicJobs) {
        this.publicJobs = publicJobs;
        return this;
    }

    public String getRepositoryStorage() {
        return this.repositoryStorage;
    }

    public void setRepositoryStorage(String repositoryStorage) {
        this.repositoryStorage = repositoryStorage;
    }

    public Project withRepositoryStorage(String repositoryStorage) {
        this.repositoryStorage = repositoryStorage;
        return this;
    }

    public Boolean getRequestAccessEnabled() {
        return this.requestAccessEnabled;
    }

    public void setRequestAccessEnabled(Boolean request_access_enabled) {
        this.requestAccessEnabled = request_access_enabled;
    }

    public Project withRequestAccessEnabled(Boolean requestAccessEnabled) {
        this.requestAccessEnabled = requestAccessEnabled;
        return this;
    }

    public String getRunnersToken() {
        return this.runnersToken;
    }

    public void setRunnersToken(String runnersToken) {
        this.runnersToken = runnersToken;
    }

    public Boolean getSharedRunnersEnabled() {
        return this.sharedRunnersEnabled;
    }

    public void setSharedRunnersEnabled(Boolean sharedRunnersEnabled) {
        this.sharedRunnersEnabled = sharedRunnersEnabled;
    }

    public List<SharedGroup> getSharedWithGroups() {
        return this.sharedWithGroups;
    }

    public void setSharedWithGroups(List<SharedGroup> sharedWithGroups) {
        this.sharedWithGroups = sharedWithGroups;
    }

    public Project withSharedRunnersEnabled(Boolean sharedRunnersEnabled) {
        this.sharedRunnersEnabled = sharedRunnersEnabled;
        return this;
    }

    public Boolean getSnippetsEnabled() {
        return this.snippetsEnabled;
    }

    public void setSnippetsEnabled(Boolean snippetsEnabled) {
        this.snippetsEnabled = snippetsEnabled;
    }

    public Project withSnippetsEnabled(Boolean snippetsEnabled) {
        this.snippetsEnabled = snippetsEnabled;
        return this;
    }

    public String getSshUrlToRepo() {
        return this.sshUrlToRepo;
    }

    public void setSshUrlToRepo(String sshUrlToRepo) {
        this.sshUrlToRepo = sshUrlToRepo;
    }

    public Integer getStarCount() {
        return this.starCount;
    }

    public void setStarCount(Integer starCount) {
        this.starCount = starCount;
    }

    @Deprecated
    public List<String> getTagList() {
        return this.tagList;
    }

    @Deprecated
    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    @Deprecated
    public Project withTagList(List<String> tagList) {
        this.tagList = tagList;
        return this;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public Project withTopics(List<String> topics) {
        this.topics = topics;
        return this;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Project withVisibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public Integer getVisibilityLevel() {
        return this.visibilityLevel;
    }

    public void setVisibilityLevel(Integer visibilityLevel) {
        this.visibilityLevel = visibilityLevel;
    }

    public Project withVisibilityLevel(Integer visibilityLevel) {
        this.visibilityLevel = visibilityLevel;
        return this;
    }

    public Boolean getWallEnabled() {
        return this.wallEnabled;
    }

    public void setWallEnabled(Boolean wallEnabled) {
        this.wallEnabled = wallEnabled;
    }

    public Project withWallEnabled(Boolean wallEnabled) {
        this.wallEnabled = wallEnabled;
        return this;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public Project withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public Boolean getWikiEnabled() {
        return this.wikiEnabled;
    }

    public void setWikiEnabled(Boolean wikiEnabled) {
        this.wikiEnabled = wikiEnabled;
    }

    public Project withWikiEnabled(Boolean wikiEnabled) {
        this.wikiEnabled = wikiEnabled;
        return this;
    }

    public Boolean getPrintingMergeRequestLinkEnabled() {
        return this.printingMergeRequestLinkEnabled;
    }

    public void setPrintingMergeRequestLinkEnabled(Boolean printingMergeRequestLinkEnabled) {
        this.printingMergeRequestLinkEnabled = printingMergeRequestLinkEnabled;
    }

    public Project withPrintingMergeRequestLinkEnabled(Boolean printingMergeRequestLinkEnabled) {
        this.printingMergeRequestLinkEnabled = printingMergeRequestLinkEnabled;
        return this;
    }

    public Boolean getResolveOutdatedDiffDiscussions() {
        return this.resolveOutdatedDiffDiscussions;
    }

    public void setResolveOutdatedDiffDiscussions(Boolean resolveOutdatedDiffDiscussions) {
        this.resolveOutdatedDiffDiscussions = resolveOutdatedDiffDiscussions;
    }

    public Project withResolveOutdatedDiffDiscussions(Boolean resolveOutdatedDiffDiscussions) {
        this.resolveOutdatedDiffDiscussions = resolveOutdatedDiffDiscussions;
        return this;
    }

    public Boolean getInitializeWithReadme() {
        return this.initializeWithReadme;
    }

    public void setInitializeWithReadme(Boolean initializeWithReadme) {
        this.initializeWithReadme = initializeWithReadme;
    }

    public Project withInitializeWithReadme(Boolean initializeWithReadme) {
        this.initializeWithReadme = initializeWithReadme;
        return this;
    }

    public Boolean getPackagesEnabled() {
        return this.packagesEnabled;
    }

    public void setPackagesEnabled(Boolean packagesEnabled) {
        this.packagesEnabled = packagesEnabled;
    }

    public Project withPackagesEnabled(Boolean packagesEnabled) {
        this.packagesEnabled = packagesEnabled;
        return this;
    }

    public ProjectStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(ProjectStatistics statistics) {
        this.statistics = statistics;
    }

    public Boolean getEmptyRepo() {
        return this.emptyRepo;
    }

    public void setEmptyRepo(Boolean emptyRepo) {
        this.emptyRepo = emptyRepo;
    }

    public Date getMarkedForDeletionOn() {
        return this.markedForDeletionOn;
    }

    public void setMarkedForDeletionOn(Date markedForDeletionOn) {
        this.markedForDeletionOn = markedForDeletionOn;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public ProjectLicense getLicense() {
        return this.license;
    }

    public void setLicense(ProjectLicense license) {
        this.license = license;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public static boolean isValid(Project project) {
        return project != null && project.getId() != null;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }

    public static final String getPathWithNammespace(String namespace, String path) {
        return namespace.trim() + "/" + path.trim();
    }

    public String getBuildCoverageRegex() {
        return this.buildCoverageRegex;
    }

    public void setBuildCoverageRegex(String buildCoverageRegex) {
        this.buildCoverageRegex = buildCoverageRegex;
    }

    public Project withBuildCoverageRegex(String buildCoverageRegex) {
        this.buildCoverageRegex = buildCoverageRegex;
        return this;
    }

    public Constants.BuildGitStrategy getBuildGitStrategy() {
        return this.buildGitStrategy;
    }

    public void setBuildGitStrategy(Constants.BuildGitStrategy buildGitStrategy) {
        this.buildGitStrategy = buildGitStrategy;
    }

    public Project withBuildGitStrategy(Constants.BuildGitStrategy buildGitStrategy) {
        this.buildGitStrategy = buildGitStrategy;
        return this;
    }

    public String getReadmeUrl() {
        return this.readmeUrl;
    }

    public void setReadmeUrl(String readmeUrl) {
        this.readmeUrl = readmeUrl;
    }

    public Boolean getCanCreateMergeRequestIn() {
        return this.canCreateMergeRequestIn;
    }

    public void setCanCreateMergeRequestIn(Boolean canCreateMergeRequestIn) {
        this.canCreateMergeRequestIn = canCreateMergeRequestIn;
    }

    public ImportStatus.Status getImportStatus() {
        return this.importStatus;
    }

    public void setImportStatus(ImportStatus.Status importStatus) {
        this.importStatus = importStatus;
    }

    public Integer getCiDefaultGitDepth() {
        return this.ciDefaultGitDepth;
    }

    public void setCiDefaultGitDepth(Integer ciDefaultGitDepth) {
        this.ciDefaultGitDepth = ciDefaultGitDepth;
    }

    public Boolean getCiForwardDeploymentEnabled() {
        return this.ciForwardDeploymentEnabled;
    }

    public void setCiForwardDeploymentEnabled(Boolean ciForwardDeploymentEnabled) {
        this.ciForwardDeploymentEnabled = ciForwardDeploymentEnabled;
    }

    public String getCiConfigPath() {
        return this.ciConfigPath;
    }

    public void setCiConfigPath(String ciConfigPath) {
        this.ciConfigPath = ciConfigPath;
    }

    public Project withCiConfigPath(String ciConfigPath) {
        this.ciConfigPath = ciConfigPath;
        return this;
    }

    public Boolean getRemoveSourceBranchAfterMerge() {
        return this.removeSourceBranchAfterMerge;
    }

    public void setRemoveSourceBranchAfterMerge(Boolean removeSourceBranchAfterMerge) {
        this.removeSourceBranchAfterMerge = removeSourceBranchAfterMerge;
    }

    public Project withRemoveSourceBranchAfterMerge(Boolean removeSourceBranchAfterMerge) {
        this.removeSourceBranchAfterMerge = removeSourceBranchAfterMerge;
        return this;
    }

    public Boolean getAutoDevopsEnabled() {
        return this.autoDevopsEnabled;
    }

    public void setAutoDevopsEnabled(Boolean autoDevopsEnabled) {
        this.autoDevopsEnabled = autoDevopsEnabled;
    }

    public Project withAutoDevopsEnabled(Boolean autoDevopsEnabled) {
        this.autoDevopsEnabled = autoDevopsEnabled;
        return this;
    }

    public Constants.AutoDevopsDeployStrategy getAutoDevopsDeployStrategy() {
        return this.autoDevopsDeployStrategy;
    }

    public void setAutoDevopsDeployStrategy(Constants.AutoDevopsDeployStrategy autoDevopsDeployStrategy) {
        this.autoDevopsDeployStrategy = autoDevopsDeployStrategy;
    }

    public Boolean getAutocloseReferencedIssues() {
        return this.autocloseReferencedIssues;
    }

    public void setAutocloseReferencedIssues(Boolean autocloseReferencedIssues) {
        this.autocloseReferencedIssues = autocloseReferencedIssues;
    }

    public Project withAutocloseReferencedIssues(Boolean autocloseReferencedIssues) {
        this.autocloseReferencedIssues = autocloseReferencedIssues;
        return this;
    }

    public Boolean getEmailsDisabled() {
        return this.emailsDisabled;
    }

    public void setEmailsDisabled(Boolean emailsDisabled) {
        this.emailsDisabled = emailsDisabled;
    }

    public Project withEmailsDisabled(Boolean emailsDisabled) {
        this.emailsDisabled = emailsDisabled;
        return this;
    }

    public String getSuggestionCommitMessage() {
        return this.suggestionCommitMessage;
    }

    public Project withSuggestionCommitMessage(String suggestionCommitMessage) {
        this.suggestionCommitMessage = suggestionCommitMessage;
        return this;
    }

    public void setSuggestionCommitMessage(String suggestionCommitMessage) {
        this.suggestionCommitMessage = suggestionCommitMessage;
    }

    public Constants.SquashOption getSquashOption() {
        return this.squashOption;
    }

    public void setSquashOption(Constants.SquashOption squashOption) {
        this.squashOption = squashOption;
    }

    public Project withSquashOption(Constants.SquashOption squashOption) {
        this.squashOption = squashOption;
        return this;
    }

    public String getMergeCommitTemplate() {
        return this.mergeCommitTemplate;
    }

    public void setMergeCommitTemplate(String mergeCommitTemplate) {
        this.mergeCommitTemplate = mergeCommitTemplate;
    }

    public String getSquashCommitTemplate() {
        return this.squashCommitTemplate;
    }

    public void setSquashCommitTemplate(String squashCommitTemplate) {
        this.squashCommitTemplate = squashCommitTemplate;
    }

    public String getIssueBranchTemplate() {
        return this.issueBranchTemplate;
    }

    public void setIssueBranchTemplate(String issueBranchTemplate) {
        this.issueBranchTemplate = issueBranchTemplate;
    }

    public String getMergeRequestsTemplate() {
        return this.mergeRequestsTemplate;
    }

    public void setMergeRequestsTemplate(String mergeRequestsTemplate) {
        this.mergeRequestsTemplate = mergeRequestsTemplate;
    }

    public String getIssuesTemplate() {
        return this.issuesTemplate;
    }

    public void setIssuesTemplate(String issuesTemplate) {
        this.issuesTemplate = issuesTemplate;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    public Integer getBuildTimeout() {
        return this.buildTimeout;
    }

    public void setBuildTimeout(Integer buildTimeout) {
        this.buildTimeout = buildTimeout;
    }

    public Project withBuildTimeout(Integer buildTimeout) {
        this.buildTimeout = buildTimeout;
        return this;
    }

    public Boolean getMirrorTriggerBuilds() {
        return this.mirrorTriggerBuilds;
    }

    public void setMirrorTriggerBuilds(Boolean mirrorTriggerBuilds) {
        this.mirrorTriggerBuilds = mirrorTriggerBuilds;
    }

    public Project withMirrorTriggerBuilds(Boolean mirrorTriggerBuilds) {
        this.mirrorTriggerBuilds = mirrorTriggerBuilds;
        return this;
    }

    public Integer getGroupWithProjectTemplatesId() {
        return this.groupWithProjectTemplatesId;
    }

    public void setGroupWithProjectTemplatesId(Integer groupWithProjectTemplatesId) {
        this.groupWithProjectTemplatesId = groupWithProjectTemplatesId;
    }

    public Project withGroupWithProjectTemplatesId(Integer groupWithProjectTemplatesId) {
        this.groupWithProjectTemplatesId = groupWithProjectTemplatesId;
        return this;
    }

    public Boolean getGroupRunnersEnabled() {
        return this.groupRunnersEnabled;
    }

    public void setGroupRunnersEnabled(Boolean groupRunnersEnabled) {
        this.groupRunnersEnabled = groupRunnersEnabled;
    }

    public Project withGroupRunnersEnabled(Boolean groupRunnersEnabled) {
        this.groupRunnersEnabled = groupRunnersEnabled;
        return this;
    }

    public Boolean getOnlyAllowMergeIfAllStatusChecksPassed() {
        return this.onlyAllowMergeIfAllStatusChecksPassed;
    }

    public void setOnlyAllowMergeIfAllStatusChecksPassed(Boolean onlyAllowMergeIfAllStatusChecksPassed) {
        this.onlyAllowMergeIfAllStatusChecksPassed = onlyAllowMergeIfAllStatusChecksPassed;
    }

    public Project withOnlyAllowMergeIfAllStatusChecksPassed(Boolean onlyAllowMergeIfAllStatusChecksPassed) {
        this.onlyAllowMergeIfAllStatusChecksPassed = onlyAllowMergeIfAllStatusChecksPassed;
        return this;
    }

    public Boolean getPublicBuilds() {
        return this.publicBuilds;
    }

    public void setPublicBuilds(Boolean publicBuilds) {
        this.publicBuilds = publicBuilds;
    }

    public Project withPublicBuilds(Boolean publicBuilds) {
        this.publicBuilds = publicBuilds;
        return this;
    }

    public String getRepositoryObjectFormat() {
        return this.repositoryObjectFormat;
    }

    public void setRepositoryObjectFormat(String repositoryObjectFormat) {
        this.repositoryObjectFormat = repositoryObjectFormat;
    }

    public Project withRepositoryObjectFormat(String repositoryObjectFormat) {
        this.repositoryObjectFormat = repositoryObjectFormat;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Project withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getExternalAuthorizationClassificationLabel() {
        return this.externalAuthorizationClassificationLabel;
    }

    public void setExternalAuthorizationClassificationLabel(String externalAuthorizationClassificationLabel) {
        this.externalAuthorizationClassificationLabel = externalAuthorizationClassificationLabel;
    }

    public Project withExternalAuthorizationClassificationLabel(String externalAuthorizationClassificationLabel) {
        this.externalAuthorizationClassificationLabel = externalAuthorizationClassificationLabel;
        return this;
    }

    public Constants.AutoCancelPendingPipelines getAutoCancelPendingPipelines() {
        return this.autoCancelPendingPipelines;
    }

    public void setAutoCancelPendingPipelines(Constants.AutoCancelPendingPipelines autoCancelPendingPipelines) {
        this.autoCancelPendingPipelines = autoCancelPendingPipelines;
    }

    public Project withAutoCancelPendingPipelines(Constants.AutoCancelPendingPipelines autoCancelPendingPipelines) {
        this.autoCancelPendingPipelines = autoCancelPendingPipelines;
        return this;
    }

    public Boolean getUseCustomTemplate() {
        return this.useCustomTemplate;
    }

    public void setUseCustomTemplate(Boolean useCustomTemplate) {
        this.useCustomTemplate = useCustomTemplate;
    }

    public Project withUseCustomTemplate(Boolean useCustomTemplate) {
        this.useCustomTemplate = useCustomTemplate;
        return this;
    }

    public Boolean getEmailsEnabled() {
        return this.emailsEnabled;
    }

    public void setEmailsEnabled(Boolean emailsEnabled) {
        this.emailsEnabled = emailsEnabled;
    }

    public Project withEmailsEnabled(Boolean emailsEnabled) {
        this.emailsEnabled = emailsEnabled;
        return this;
    }

    public Boolean getShowDefaultAwardEmojis() {
        return this.showDefaultAwardEmojis;
    }

    public void setShowDefaultAwardEmojis(Boolean showDefaultAwardEmojis) {
        this.showDefaultAwardEmojis = showDefaultAwardEmojis;
    }

    public Project withShowDefaultAwardEmojis(Boolean showDefaultAwardEmojis) {
        this.showDefaultAwardEmojis = showDefaultAwardEmojis;
        return this;
    }

    public Boolean getWarnAboutPotentiallyUnwantedCharacters() {
        return this.warnAboutPotentiallyUnwantedCharacters;
    }

    public void setWarnAboutPotentiallyUnwantedCharacters(Boolean warnAboutPotentiallyUnwantedCharacters) {
        this.warnAboutPotentiallyUnwantedCharacters = warnAboutPotentiallyUnwantedCharacters;
    }

    public Project withWarnAboutPotentiallyUnwantedCharacters(Boolean warnAboutPotentiallyUnwantedCharacters) {
        this.warnAboutPotentiallyUnwantedCharacters = warnAboutPotentiallyUnwantedCharacters;
        return this;
    }

    public Boolean getMirror() {
        return this.mirror;
    }

    public void setMirror(Boolean mirror) {
        this.mirror = mirror;
    }

    public Project withMirror(Boolean mirror) {
        this.mirror = mirror;
        return this;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getDescriptionHtml() {
        return this.descriptionHtml;
    }

    public void setDescriptionHtml(String descriptionHtml) {
        this.descriptionHtml = descriptionHtml;
    }

    public String getContainerRegistryImagePrefix() {
        return this.containerRegistryImagePrefix;
    }

    public void setContainerRegistryImagePrefix(String containerRegistryImagePrefix) {
        this.containerRegistryImagePrefix = containerRegistryImagePrefix;
    }

    public ContainerExpirationPolicy getContainerExpirationPolicy() {
        return this.containerExpirationPolicy;
    }

    public void setContainerExpirationPolicy(ContainerExpirationPolicy containerExpirationPolicy) {
        this.containerExpirationPolicy = containerExpirationPolicy;
    }

    public Project withContainerExpirationPolicy(ContainerExpirationPolicy containerExpirationPolicy) {
        this.containerExpirationPolicy = containerExpirationPolicy;
        return this;
    }

    public Boolean getServiceDeskEnabled() {
        return this.serviceDeskEnabled;
    }

    public void setServiceDeskEnabled(Boolean serviceDeskEnabled) {
        this.serviceDeskEnabled = serviceDeskEnabled;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String importUrl) {
        this.importUrl = importUrl;
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    public String getImportError() {
        return this.importError;
    }

    public void setImportError(String importError) {
        this.importError = importError;
    }

    public Boolean getCiForwardDeploymentRollbackAllowed() {
        return this.ciForwardDeploymentRollbackAllowed;
    }

    public void setCiForwardDeploymentRollbackAllowed(Boolean ciForwardDeploymentRollbackAllowed) {
        this.ciForwardDeploymentRollbackAllowed = ciForwardDeploymentRollbackAllowed;
    }

    public Boolean getCiAllowForkPipelinesToRunInParentProject() {
        return this.ciAllowForkPipelinesToRunInParentProject;
    }

    public void setCiAllowForkPipelinesToRunInParentProject(Boolean ciAllowForkPipelinesToRunInParentProject) {
        this.ciAllowForkPipelinesToRunInParentProject = ciAllowForkPipelinesToRunInParentProject;
    }

    public List<String> getCiIdTokenSubClaimComponents() {
        return this.ciIdTokenSubClaimComponents;
    }

    public void setCiIdTokenSubClaimComponents(List<String> ciIdTokenSubClaimComponents) {
        this.ciIdTokenSubClaimComponents = ciIdTokenSubClaimComponents;
    }

    public Boolean getCiJobTokenScopeEnabled() {
        return this.ciJobTokenScopeEnabled;
    }

    public void setCiJobTokenScopeEnabled(Boolean ciJobTokenScopeEnabled) {
        this.ciJobTokenScopeEnabled = ciJobTokenScopeEnabled;
    }

    public Boolean getCiSeparatedCaches() {
        return this.ciSeparatedCaches;
    }

    public void setCiSeparatedCaches(Boolean ciSeparatedCaches) {
        this.ciSeparatedCaches = ciSeparatedCaches;
    }

    public String getCiRestrictPipelineCancellationRole() {
        return this.ciRestrictPipelineCancellationRole;
    }

    public void setCiRestrictPipelineCancellationRole(String ciRestrictPipelineCancellationRole) {
        this.ciRestrictPipelineCancellationRole = ciRestrictPipelineCancellationRole;
    }

    public String getCiPipelineVariablesMinimumOverrideRole() {
        return this.ciPipelineVariablesMinimumOverrideRole;
    }

    public void setCiPipelineVariablesMinimumOverrideRole(String ciPipelineVariablesMinimumOverrideRole) {
        this.ciPipelineVariablesMinimumOverrideRole = ciPipelineVariablesMinimumOverrideRole;
    }

    public Boolean getCiPushRepositoryForJobTokenAllowed() {
        return this.ciPushRepositoryForJobTokenAllowed;
    }

    public void setCiPushRepositoryForJobTokenAllowed(Boolean ciPushRepositoryForJobTokenAllowed) {
        this.ciPushRepositoryForJobTokenAllowed = ciPushRepositoryForJobTokenAllowed;
    }

    public Boolean getAllowPipelineTriggerApproveDeployment() {
        return this.allowPipelineTriggerApproveDeployment;
    }

    public void setAllowPipelineTriggerApproveDeployment(Boolean allowPipelineTriggerApproveDeployment) {
        this.allowPipelineTriggerApproveDeployment = allowPipelineTriggerApproveDeployment;
    }

    public Boolean getRestrictUserDefinedVariables() {
        return this.restrictUserDefinedVariables;
    }

    public void setRestrictUserDefinedVariables(Boolean restrictUserDefinedVariables) {
        this.restrictUserDefinedVariables = restrictUserDefinedVariables;
    }

    public Boolean getEnforceAuthChecksOnUploads() {
        return this.enforceAuthChecksOnUploads;
    }

    public void setEnforceAuthChecksOnUploads(Boolean enforceAuthChecksOnUploads) {
        this.enforceAuthChecksOnUploads = enforceAuthChecksOnUploads;
    }

    public Boolean getKeepLatestArtifact() {
        return this.keepLatestArtifact;
    }

    public void setKeepLatestArtifact(Boolean keepLatestArtifact) {
        this.keepLatestArtifact = keepLatestArtifact;
    }

    public Integer getRunnerTokenExpirationInterval() {
        return this.runnerTokenExpirationInterval;
    }

    public void setRunnerTokenExpirationInterval(Integer runnerTokenExpirationInterval) {
        this.runnerTokenExpirationInterval = runnerTokenExpirationInterval;
    }

    public Boolean getRequirementsEnabled() {
        return this.requirementsEnabled;
    }

    public void setRequirementsEnabled(Boolean requirementsEnabled) {
        this.requirementsEnabled = requirementsEnabled;
    }

    public Boolean getSecurityAndComplianceEnabled() {
        return this.securityAndComplianceEnabled;
    }

    public void setSecurityAndComplianceEnabled(Boolean securityAndComplianceEnabled) {
        this.securityAndComplianceEnabled = securityAndComplianceEnabled;
    }

    public Boolean getSecretPushProtectionEnabled() {
        return this.secretPushProtectionEnabled;
    }

    public void setSecretPushProtectionEnabled(Boolean secretPushProtectionEnabled) {
        this.secretPushProtectionEnabled = secretPushProtectionEnabled;
    }

    public List<String> getComplianceFrameworks() {
        return this.complianceFrameworks;
    }

    public void setComplianceFrameworks(List<String> complianceFrameworks) {
        this.complianceFrameworks = complianceFrameworks;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getAnalyticsAccessLevel() {
        return this.analyticsAccessLevel;
    }

    public void setAnalyticsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel analyticsAccessLevel) {
        this.analyticsAccessLevel = analyticsAccessLevel;
    }

    public Project withAnalyticsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel analyticsAccessLevel) {
        this.analyticsAccessLevel = analyticsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getBuildsAccessLevel() {
        return this.buildsAccessLevel;
    }

    public void setBuildsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel buildsAccessLevel) {
        this.buildsAccessLevel = buildsAccessLevel;
    }

    public Project withBuildsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel buildsAccessLevel) {
        this.buildsAccessLevel = buildsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getContainerRegistryAccessLevel() {
        return this.containerRegistryAccessLevel;
    }

    public void setContainerRegistryAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel containerRegistryAccessLevel) {
        this.containerRegistryAccessLevel = containerRegistryAccessLevel;
    }

    public Project withContainerRegistryAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel containerRegistryAccessLevel) {
        this.containerRegistryAccessLevel = containerRegistryAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getEnvironmentsAccessLevel() {
        return this.environmentsAccessLevel;
    }

    public void setEnvironmentsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel environmentsAccessLevel) {
        this.environmentsAccessLevel = environmentsAccessLevel;
    }

    public Project withEnvironmentsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel environmentsAccessLevel) {
        this.environmentsAccessLevel = environmentsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getFeatureFlagsAccessLevel() {
        return this.featureFlagsAccessLevel;
    }

    public void setFeatureFlagsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel featureFlagsAccessLevel) {
        this.featureFlagsAccessLevel = featureFlagsAccessLevel;
    }

    public Project withFeatureFlagsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel featureFlagsAccessLevel) {
        this.featureFlagsAccessLevel = featureFlagsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getForkingAccessLevel() {
        return this.forkingAccessLevel;
    }

    public void setForkingAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel forkingAccessLevel) {
        this.forkingAccessLevel = forkingAccessLevel;
    }

    public Project withForkingAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel forkingAccessLevel) {
        this.forkingAccessLevel = forkingAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getInfrastructureAccessLevel() {
        return this.infrastructureAccessLevel;
    }

    public void setInfrastructureAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel infrastructureAccessLevel) {
        this.infrastructureAccessLevel = infrastructureAccessLevel;
    }

    public Project withInfrastructureAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel infrastructureAccessLevel) {
        this.infrastructureAccessLevel = infrastructureAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getIssuesAccessLevel() {
        return this.issuesAccessLevel;
    }

    public void setIssuesAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel issuesAccessLevel) {
        this.issuesAccessLevel = issuesAccessLevel;
    }

    public Project withIssuesAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel issuesAccessLevel) {
        this.issuesAccessLevel = issuesAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getMergeRequestsAccessLevel() {
        return this.mergeRequestsAccessLevel;
    }

    public void setMergeRequestsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel mergeRequestsAccessLevel) {
        this.mergeRequestsAccessLevel = mergeRequestsAccessLevel;
    }

    public Project withMergeRequestsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel mergeRequestsAccessLevel) {
        this.mergeRequestsAccessLevel = mergeRequestsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getModelExperimentsAccessLevel() {
        return this.modelExperimentsAccessLevel;
    }

    public void setModelExperimentsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel modelExperimentsAccessLevel) {
        this.modelExperimentsAccessLevel = modelExperimentsAccessLevel;
    }

    public Project withModelExperimentsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel modelExperimentsAccessLevel) {
        this.modelExperimentsAccessLevel = modelExperimentsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getModelRegistryAccessLevel() {
        return this.modelRegistryAccessLevel;
    }

    public void setModelRegistryAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel modelRegistryAccessLevel) {
        this.modelRegistryAccessLevel = modelRegistryAccessLevel;
    }

    public Project withModelRegistryAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel modelRegistryAccessLevel) {
        this.modelRegistryAccessLevel = modelRegistryAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getMonitorAccessLevel() {
        return this.monitorAccessLevel;
    }

    public void setMonitorAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel monitorAccessLevel) {
        this.monitorAccessLevel = monitorAccessLevel;
    }

    public Project withMonitorAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel monitorAccessLevel) {
        this.monitorAccessLevel = monitorAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getPagesAccessLevel() {
        return this.pagesAccessLevel;
    }

    public void setPagesAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel pagesAccessLevel) {
        this.pagesAccessLevel = pagesAccessLevel;
    }

    public Project withPagesAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel pagesAccessLevel) {
        this.pagesAccessLevel = pagesAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getReleasesAccessLevel() {
        return this.releasesAccessLevel;
    }

    public void setReleasesAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel releasesAccessLevel) {
        this.releasesAccessLevel = releasesAccessLevel;
    }

    public Project withReleasesAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel releasesAccessLevel) {
        this.releasesAccessLevel = releasesAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getRepositoryAccessLevel() {
        return this.repositoryAccessLevel;
    }

    public void setRepositoryAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel repositoryAccessLevel) {
        this.repositoryAccessLevel = repositoryAccessLevel;
    }

    public Project withRepositoryAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel repositoryAccessLevel) {
        this.repositoryAccessLevel = repositoryAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getRequirementsAccessLevel() {
        return this.requirementsAccessLevel;
    }

    public void setRequirementsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel requirementsAccessLevel) {
        this.requirementsAccessLevel = requirementsAccessLevel;
    }

    public Project withRequirementsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel requirementsAccessLevel) {
        this.requirementsAccessLevel = requirementsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getSecurityAndComplianceAccessLevel() {
        return this.securityAndComplianceAccessLevel;
    }

    public void setSecurityAndComplianceAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel securityAndComplianceAccessLevel) {
        this.securityAndComplianceAccessLevel = securityAndComplianceAccessLevel;
    }

    public Project withSecurityAndComplianceAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel securityAndComplianceAccessLevel) {
        this.securityAndComplianceAccessLevel = securityAndComplianceAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getSnippetsAccessLevel() {
        return this.snippetsAccessLevel;
    }

    public void setSnippetsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel snippetsAccessLevel) {
        this.snippetsAccessLevel = snippetsAccessLevel;
    }

    public Project withSnippetsAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel snippetsAccessLevel) {
        this.snippetsAccessLevel = snippetsAccessLevel;
        return this;
    }

    public Constants.ProjectFeatureVisibilityAccessLevel getWikiAccessLevel() {
        return this.wikiAccessLevel;
    }

    public void setWikiAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel wikiAccessLevel) {
        this.wikiAccessLevel = wikiAccessLevel;
    }

    public Project withWikiAccessLevel(Constants.ProjectFeatureVisibilityAccessLevel wikiAccessLevel) {
        this.wikiAccessLevel = wikiAccessLevel;
        return this;
    }

    @JsonIgnore
    public String getLinkByName(String name) {
        if (this.links == null || this.links.isEmpty()) {
            return null;
        }
        return this.links.get(name);
    }

    public static enum MergeMethod {
        MERGE,
        REBASE_MERGE,
        FF;

        private static JacksonJsonEnumHelper<MergeMethod> enumHelper;

        @JsonCreator
        public static MergeMethod forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeMethod>(MergeMethod.class);
        }
    }
}

