/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Application;
import gitlabbt.org.gitlab4j.models.Constants;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationsApi
extends AbstractApi {
    public ApplicationsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Application> getApplications() throws GitLabApiException {
        return this.getApplications(this.getDefaultPerPage()).all();
    }

    public List<Application> getApplications(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "applications");
        return response.readEntity(new GenericType<List<Application>>(){});
    }

    public Pager<Application> getApplications(int itemsPerPage) throws GitLabApiException {
        return new Pager<Application>(this, Application.class, itemsPerPage, null, "applications");
    }

    public Stream<Application> getApplicationsStream() throws GitLabApiException {
        return this.getApplications(this.getDefaultPerPage()).stream();
    }

    @Deprecated
    public Application createApplication(String name, String redirectUri, Constants.ApplicationScope[] scopes) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new GitLabApiException("scopes cannot be null or empty");
        }
        return this.createApplication(name, redirectUri, Arrays.asList(scopes));
    }

    @Deprecated
    public Application createApplication(String name, String redirectUri, List<Constants.ApplicationScope> scopes) throws GitLabApiException {
        return this.createApplication(name, redirectUri, scopes, null);
    }

    public Application createApplication(String name, String redirectUri, List<Constants.ApplicationScope> scopes, Boolean confidential) throws GitLabApiException {
        if (scopes == null || scopes.isEmpty()) {
            throw new GitLabApiException("scopes cannot be null or empty");
        }
        String scopesString = scopes.stream().map(Constants.ApplicationScope::toString).collect(Collectors.joining(" "));
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("redirect_uri", redirectUri, true).withParam("scopes", scopesString, true).withParam("confidential", confidential);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "applications");
        return response.readEntity(Application.class);
    }

    public void deleteApplication(Long applicationId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "applications", applicationId);
    }

    public Application renewSecret(Long applicationId) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, "applications", applicationId, "renew-secret");
        return response.readEntity(Application.class);
    }
}

