/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.controller;

import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.squashtest.tm.plugin.saml.SAMLActivationSwitch;

@Controller
@RequestMapping(value={"/auth/saml/authentication-failure"})
@SAMLActivationSwitch
public class SquashSAMLAuthFailureController {
    public static final String FAIL_URL = "/auth/saml/authentication-failure";
    public static final String FAIL_TEMPLATE = "saml/authentication-failure.html";
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashSAMLAuthFailureController.class);

    @RequestMapping(method={RequestMethod.GET})
    public String showAuthenticationFailure(HttpSession session, Model model) {
        LOGGER.debug("BEGIN saml auth failure page");
        Exception ex = this.extractException(session);
        AutopsyReport report = null;
        if (session == null || ex == null) {
            LOGGER.error("No session nor authentication exception available for analysis, cannot tell what has gone wrong !");
        } else {
            report = this.autopsy(ex);
            if (report.reason == FailureReason.UNKNOWN) {
                LOGGER.error("Couldn't find why the auth problem occurred. Original exception is :", (Throwable)ex);
            } else {
                LOGGER.trace("Error can be gracefully handled. Original exception is : ", (Throwable)ex);
            }
        }
        model.addAttribute("report", (Object)report);
        if (report != null && report.cause != null) {
            model.addAttribute("causeName", (Object)report.cause.getClass().getSimpleName());
            model.addAttribute("causeMessage", (Object)report.cause.getMessage());
        }
        LOGGER.debug("END saml auth failure page");
        return FAIL_TEMPLATE;
    }

    private Exception extractException(HttpSession session) {
        return session != null ? (Exception)session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION") : null;
    }

    private AutopsyReport autopsy(Exception ex) {
        LOGGER.debug("looking for the cause of the authentication failure");
        AutopsyReport report = null;
        int cap = 6;
        int cnt = 0;
        Throwable cause = ex;
        LOGGER.trace("unwinding the cause chain");
        while (cnt++ < cap && cause.getCause() != null) {
            cause = cause.getCause();
        }
        LOGGER.trace("building report");
        report = cnt >= cap ? new AutopsyReport(FailureReason.UNKNOWN, cause, false) : (this.credentialsExpired(cause) ? new AutopsyReport(FailureReason.IDP_AUTH_EXPIRED, cause, true) : (this.responseValidationError(cause) ? new AutopsyReport(FailureReason.ASSERTION_VALIDATION, cause, true) : new AutopsyReport(FailureReason.UNKNOWN, cause, true)));
        if (LOGGER.isTraceEnabled()) {
            this.logAutopsy(report);
        }
        return report;
    }

    private boolean credentialsExpired(Throwable cause) {
        return CredentialsExpiredException.class.isAssignableFrom(cause.getClass());
    }

    private boolean responseValidationError(Throwable cause) {
        boolean isClazz = Saml2AuthenticationException.class.isAssignableFrom(cause.getClass());
        String message = cause.getMessage();
        if (message == null) {
            return false;
        }
        return isClazz && message.startsWith("Invalid assertion");
    }

    private void logAutopsy(AutopsyReport report) {
        switch (report.reason) {
            case UNKNOWN: {
                StringBuilder errBuilder = new StringBuilder("No business error found. The cause is thus probably a technical error. ");
                if (!report.completed) {
                    errBuilder.append("Note : the cause chain was longer than expected so the search had to be aborded before getting to the bottom of this.");
                }
                LOGGER.trace(errBuilder.toString());
                break;
            }
            case IDP_AUTH_EXPIRED: {
                LOGGER.trace("The IDP assertion is expired and the user needs to reauthenticate to the IDP.");
                break;
            }
            case ASSERTION_VALIDATION: {
                LOGGER.trace("An assertion validation error occurred. The assertion is invalid.");
                break;
            }
        }
    }

    protected static final class AutopsyReport {
        private boolean completed;
        private FailureReason reason;
        private Throwable cause;

        AutopsyReport(FailureReason reason, Throwable cause, boolean completed) {
            this.completed = completed;
            this.reason = reason;
            this.cause = cause;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public FailureReason getReason() {
            return this.reason;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutopsyReport that = (AutopsyReport)o;
            return this.completed == that.completed && this.reason == that.reason && Objects.equals(this.cause, that.cause);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.completed, this.reason, this.cause});
        }
    }

    private static enum FailureReason {
        IDP_ASSERTION_REJECTED,
        IDP_AUTH_EXPIRED,
        ASSERTION_VALIDATION,
        UNKNOWN;

    }
}

