--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-3xyj4t78 (100.64.9.73)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-1.22.2.xml
--  Ran at: 04/12/2025 18:07
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.29.2
--  *********************************************************************

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-1.22.2.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.2' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2', 'jprioux', '../tm/tm.changelog-1.22.2.xml', NOW(), 2, '9:e6c15c858f0293a04009b55a8b5b20e1', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-1-add-tc-scm-repository-id-column::jprioux
--  Add a new column in test case for link to scm repository
ALTER TABLE TEST_CASE ADD SCM_REPOSITORY_ID BIGINT NULL COMMENT 'foreign key to SCM_REPOSITORY, link to associated scm repository.';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_tc_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

CREATE INDEX idx_fk_tc_scm_repository ON TEST_CASE(SCM_REPOSITORY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-1-add-tc-scm-repository-id-column', 'jprioux', '../tm/tm.changelog-1.22.2.xml', NOW(), 3, '9:0afeda381bb6ad9b0b4a2d0a2f524a95', 'addColumn tableName=TEST_CASE; createIndex indexName=idx_fk_tc_scm_repository, tableName=TEST_CASE', 'Add a new column in test case for link to scm repository', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-2-scm-repository-url-temporary-table::jprioux
--  Create temporary table for migration
CREATE TABLE SCM_REPOSITORY_URL_MIGRATION_TEMP (TCLN_ID BIGINT NOT NULL, SOURCE_CODE_REPOSITORY_URL VARCHAR(255) NULL, SERVER_URL_FROM_TC VARCHAR(255) NULL, REPOSITORY_NAME_FROM_TC VARCHAR(255) NULL, SCM_SERVER_ID BIGINT NULL, SCM_REPOSITORY_ID BIGINT NULL, CONSTRAINT PK_SCM_REPOSITORY_URL_MIGRATION_TEMP PRIMARY KEY (TCLN_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-2-scm-repository-url-temporary-table', 'jprioux', '../tm/tm.changelog-1.22.2.xml', NOW(), 4, '9:bdec26cc2f2cdb4a65d8c5bbe250d2ea', 'createTable tableName=SCM_REPOSITORY_URL_MIGRATION_TEMP', 'Create temporary table for migration', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-3-mysql-migration-for-scm-repo-url::jprioux
--  Migration part if scm repository url has been added in tc
INSERT INTO SCM_REPOSITORY_URL_MIGRATION_TEMP
      SELECT tc.TCLN_ID,
             TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL)),
             REPLACE(TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL)), CONCAT('/', REVERSE(SUBSTRING_INDEX(REVERSE(TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL))), '/', 1))), ''),
             REVERSE(SUBSTRING_INDEX(REVERSE(TRIM(TRAILING '/' FROM TRIM(tc.SOURCE_CODE_REPOSITORY_URL))), '/', 1)),
             null,
             null
      FROM TEST_CASE tc
      WHERE tc.SOURCE_CODE_REPOSITORY_URL IS NOT NULL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN TEST_CASE_LIBRARY_NODE tcln ON mig.TCLN_ID = tcln.TCLN_ID
      JOIN PROJECT p ON tcln.PROJECT_ID = p.PROJECT_ID
      JOIN SCM_REPOSITORY repo ON p.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID AND mig.REPOSITORY_NAME_FROM_TC = repo.NAME
      JOIN THIRD_PARTY_SERVER server ON server.SERVER_ID = repo.SERVER_ID and (mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL)
      SET mig.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID, mig.SCM_SERVER_ID = repo.SERVER_ID;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN TEST_CASE_LIBRARY_NODE tcln ON mig.TCLN_ID = tcln.TCLN_ID
      JOIN PROJECT p ON tcln.PROJECT_ID = p.PROJECT_ID
      JOIN SCM_REPOSITORY repo ON p.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID
      JOIN THIRD_PARTY_SERVER server ON server.SERVER_ID = repo.SERVER_ID and (mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL)
      SET mig.SCM_SERVER_ID = repo.SERVER_ID
      WHERE mig.SCM_SERVER_ID IS NULL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN SCM_REPOSITORY repo ON mig.REPOSITORY_NAME_FROM_TC = repo.NAME
      JOIN THIRD_PARTY_SERVER server ON server.SERVER_ID = repo.SERVER_ID and (mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL)
      SET mig.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID, mig.SCM_SERVER_ID = repo.SERVER_ID
      WHERE mig.SCM_REPOSITORY_ID IS NULL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN THIRD_PARTY_SERVER server ON mig.SERVER_URL_FROM_TC = server.URL or CONCAT(mig.SERVER_URL_FROM_TC, '/') = server.URL
      JOIN SCM_SERVER scmserver ON server.SERVER_ID = scmserver.SERVER_ID
      SET mig.SCM_SERVER_ID = scmserver.SERVER_ID
      WHERE mig.SCM_SERVER_ID IS NULL;

INSERT INTO THIRD_PARTY_SERVER (NAME, URL, AUTH_POLICY, AUTH_PROTOCOL)
      SELECT CONCAT('mig_git_', mig.TCLN_ID),
              mig.SERVER_URL_FROM_TC,
              'APP_LEVEL',
              'BASIC_AUTH'
      FROM SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      WHERE mig.SCM_SERVER_ID IS NULL
      GROUP BY mig.SERVER_URL_FROM_TC;

INSERT INTO SCM_SERVER (SERVER_ID, KIND)
      SELECT server.SERVER_ID,
             'git'
      FROM THIRD_PARTY_SERVER server
      LEFT JOIN SCM_SERVER scm ON server.SERVER_ID = scm.SERVER_ID
      WHERE scm.SERVER_ID IS NULL and server.NAME LIKE 'mig_git_%';

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN THIRD_PARTY_SERVER server ON server.URL = mig.SERVER_URL_FROM_TC
      SET mig.SCM_SERVER_ID = server.SERVER_ID
      WHERE mig.SCM_SERVER_ID IS NULL;

INSERT INTO SCM_REPOSITORY (SERVER_ID, NAME, REPOSITORY_PATH, WORKING_BRANCH)
      SELECT server.SERVER_ID,
             mig.REPOSITORY_NAME_FROM_TC,
             '',
             'master'
      FROM SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN THIRD_PARTY_SERVER server ON mig.SCM_SERVER_ID = server.SERVER_ID
      WHERE mig.SCM_REPOSITORY_ID IS NULL
      GROUP BY mig.SOURCE_CODE_REPOSITORY_URL;

UPDATE SCM_REPOSITORY_URL_MIGRATION_TEMP mig
      JOIN SCM_REPOSITORY repo ON mig.SCM_SERVER_ID = repo.SERVER_ID and mig.REPOSITORY_NAME_FROM_TC = repo.NAME
      SET mig.SCM_REPOSITORY_ID = repo.SCM_REPOSITORY_ID
      WHERE mig.SCM_REPOSITORY_ID IS NULL;

UPDATE TEST_CASE tc
      JOIN SCM_REPOSITORY_URL_MIGRATION_TEMP mig ON tc.tcln_id = mig.TCLN_ID
      SET tc.SCM_REPOSITORY_ID = mig.SCM_REPOSITORY_ID
      WHERE mig.SCM_REPOSITORY_ID IS NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-3-mysql-migration-for-scm-repo-url', 'jprioux', '../tm/tm.changelog-1.22.2.xml', NOW(), 5, '9:39ed53deff59df1fd59e36f9de63eb55', 'sql; sql; sql; sql; sql', 'Migration part if scm repository url has been added in tc', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2701-4-drop-old-column-and-temp-table::jprioux
--  Drop unnecessary old column and the temporary table
ALTER TABLE TEST_CASE DROP COLUMN SOURCE_CODE_REPOSITORY_URL;

DROP TABLE SCM_REPOSITORY_URL_MIGRATION_TEMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2701-4-drop-old-column-and-temp-table', 'jprioux', '../tm/tm.changelog-1.22.2.xml', NOW(), 6, '9:84071a8139ca861184b8d9179cd0aa96', 'dropColumn columnName=SOURCE_CODE_REPOSITORY_URL, tableName=TEST_CASE; dropTable tableName=SCM_REPOSITORY_URL_MIGRATION_TEMP', 'Drop unnecessary old column and the temporary table', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-SQUASH-2834-modify-scm-repo-unique-constraint::jlor
--  Modify SCM_REPOSITORY unique constraint (name, server_id) to (name, working_branch, server_id)
CREATE TABLE SCM_REPOSITORY_DATA_TEMP (SCM_REPOSITORY_ID BIGINT NOT NULL, SERVER_ID BIGINT NOT NULL, NAME VARCHAR(255) NOT NULL, WORKING_BRANCH VARCHAR(255) NOT NULL, REPOSITORY_PATH VARCHAR(255) NOT NULL, WORKING_FOLDER_PATH VARCHAR(255) NULL, CONSTRAINT PK_SCM_REPOSITORY_DATA_TEMP PRIMARY KEY (SCM_REPOSITORY_ID), CONSTRAINT fk_scm_repository_data_temp_scm_server FOREIGN KEY (SERVER_ID) REFERENCES SCM_SERVER(SERVER_ID));

INSERT INTO SCM_REPOSITORY_DATA_TEMP (SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH)
      SELECT SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH
      FROM SCM_REPOSITORY;

ALTER TABLE PROJECT DROP FOREIGN KEY fk_project_scm_repository;

ALTER TABLE TEST_CASE DROP FOREIGN KEY fk_tc_scm_repository;

DROP TABLE SCM_REPOSITORY;

CREATE TABLE SCM_REPOSITORY (SCM_REPOSITORY_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id of the scm repository.', SERVER_ID BIGINT NOT NULL COMMENT 'The foreign key to the related SCM_SEVER', NAME VARCHAR(255) NOT NULL COMMENT 'The name of the repository.', WORKING_BRANCH VARCHAR(255) NOT NULL COMMENT 'The name of the working branch on which SquashTM will push.', REPOSITORY_PATH VARCHAR(255) NOT NULL COMMENT 'The absolute path to the local repository on the local server.', WORKING_FOLDER_PATH VARCHAR(255) NULL COMMENT 'The relative path of the working folder in which SquashTM will push.', CONSTRAINT PK_SCM_REPOSITORY PRIMARY KEY (SCM_REPOSITORY_ID), CONSTRAINT fk_scm_repository_scm_server FOREIGN KEY (SERVER_ID) REFERENCES SCM_SERVER(SERVER_ID));

ALTER TABLE SCM_REPOSITORY ADD CONSTRAINT uniq_scm_repo_name_branch_server_id UNIQUE (NAME, WORKING_BRANCH, SERVER_ID);

CREATE INDEX idx_fk_scm_repository_scm_server ON SCM_REPOSITORY(SERVER_ID);

INSERT INTO SCM_REPOSITORY (SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH)
      SELECT SCM_REPOSITORY_ID, SERVER_ID, NAME, WORKING_BRANCH, REPOSITORY_PATH, WORKING_FOLDER_PATH
      FROM SCM_REPOSITORY_DATA_TEMP;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_tc_scm_repository FOREIGN KEY (SCM_REPOSITORY_ID) REFERENCES SCM_REPOSITORY (SCM_REPOSITORY_ID);

DROP TABLE SCM_REPOSITORY_DATA_TEMP;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-SQUASH-2834-modify-scm-repo-unique-constraint', 'jlor', '../tm/tm.changelog-1.22.2.xml', NOW(), 7, '9:41df55e6b8d4336fd007d53ca33b7d7e', 'createTable tableName=SCM_REPOSITORY_DATA_TEMP; sql; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=fk_project_scm_repository; dropForeignKeyConstraint baseTableName=TEST_CASE, constraintName=fk_tc_scm_repository; dropTable tableNa...', 'Modify SCM_REPOSITORY unique constraint (name, server_id) to (name, working_branch, server_id)', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Changeset ../tm/tm.changelog-1.22.2.xml::tm-1.22.2-add-auto-test-tech::aguilhem
--  Add new compatible auto. test tech.
insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('SoapUI', 'soapui/execute@v1'),
      ('Agilitest', 'agilitest/execute@v1'),
      ('UFT', 'uft/execute@v1'),
      ('Ranorex', 'ranorex/execute@v1');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.2-add-auto-test-tech', 'aguilhem', '../tm/tm.changelog-1.22.2.xml', NOW(), 8, '9:b5ca2cc6fa07fa9683e8c5b06fe0a21d', 'sql', 'Add new compatible auto. test tech.', 'EXECUTED', NULL, NULL, '4.29.2', '4868051831');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

