/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Board;
import gitlabbt.org.gitlab4j.api.models.BoardList;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class BoardsApi
extends AbstractApi {
    public BoardsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    @Deprecated
    public List<Board> getBoards(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectIssueBoards(projectIdOrPath);
    }

    @Deprecated
    public List<Board> getBoards(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        return this.getProjectIssueBoards(projectIdOrPath);
    }

    @Deprecated
    public Pager<Board> getBoards(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getProjectIssueBoards(projectIdOrPath, itemsPerPage);
    }

    @Deprecated
    public Stream<Board> getBoardsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectIssueBoardsStream(projectIdOrPath);
    }

    @Deprecated
    public Board getBoard(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getProjectIssueBoard(projectIdOrPath, boardId);
    }

    @Deprecated
    public Optional<Board> getOptionalBoard(Object projectIdOrPath, Long boardId) {
        return this.getOptionalProjectIssueBoard(projectIdOrPath, boardId);
    }

    @Deprecated
    public Board createBoard(Object projectIdOrPath, String name) throws GitLabApiException {
        return this.createProjectIssueBoard(projectIdOrPath, name);
    }

    @Deprecated
    public Board updateBoard(Object projectIdOrPath, Long boardId, String name, Boolean hideBacklogList, Boolean hideClosedList, Long assigneeId, Long milestoneId, String labels, Integer weight) throws GitLabApiException {
        return this.updateProjectIssueBoard(projectIdOrPath, boardId, name, hideBacklogList, hideClosedList, assigneeId, milestoneId, labels, weight);
    }

    @Deprecated
    public void deleteBoard(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
    }

    @Deprecated
    public List<BoardList> getBoardLists(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getProjectIssueBoardLists(projectIdOrPath, boardId);
    }

    @Deprecated
    public List<BoardList> getBoardLists(Object projectIdOrPath, Long boardId, int page, int perPage) throws GitLabApiException {
        return this.getProjectIssueBoardLists(projectIdOrPath, boardId, page, perPage);
    }

    @Deprecated
    public Pager<BoardList> getBoardLists(Object projectIdOrPath, Long boardId, int itemsPerPage) throws GitLabApiException {
        return this.getProjectIssueBoardLists(projectIdOrPath, boardId, itemsPerPage);
    }

    @Deprecated
    public Stream<BoardList> getBoardsListsStream(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getProjectIssueBoardsListsStream(projectIdOrPath, boardId);
    }

    @Deprecated
    public BoardList getBoardList(Object projectIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        return this.getProjectIssueBoardList(projectIdOrPath, boardId, listId);
    }

    @Deprecated
    public Optional<BoardList> getOptionalBoardList(Object projectIdOrPath, Long boardId, Long listId) {
        return this.getOptionalProjectIssueBoardList(projectIdOrPath, boardId, listId);
    }

    @Deprecated
    public BoardList createBoardList(Object projectIdOrPath, Long boardId, Long labelId, Long assigneeId, Long milestoneId, Long iterationId) throws GitLabApiException {
        return this.createProjectIssueBoardList(projectIdOrPath, boardId, labelId, assigneeId, milestoneId, iterationId);
    }

    @Deprecated
    public BoardList createBoardList(Object projectIdOrPath, Long boardId, Long labelId) throws GitLabApiException {
        return this.createProjectIssueBoardList(projectIdOrPath, boardId, labelId, null, null, null);
    }

    @Deprecated
    public BoardList updateBoardList(Object projectIdOrPath, Long boardId, Long listId, Integer position) throws GitLabApiException {
        return this.updateProjectIssueBoardList(projectIdOrPath, boardId, listId, position);
    }

    @Deprecated
    public void deleteBoardList(Object projectIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        this.deleteProjectIssueBoardList(projectIdOrPath, boardId, listId);
    }

    public List<Board> getProjectIssueBoards(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectIssueBoards(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Board> getProjectIssueBoards(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
        return response.readEntity(new GenericType<List<Board>>(){});
    }

    public Pager<Board> getProjectIssueBoards(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Board>(this, Board.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
    }

    public Stream<Board> getProjectIssueBoardsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectIssueBoards(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Board getProjectIssueBoard(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
        return response.readEntity(Board.class);
    }

    public Optional<Board> getOptionalProjectIssueBoard(Object projectIdOrPath, Long boardId) {
        try {
            return Optional.ofNullable(this.getProjectIssueBoard(projectIdOrPath, boardId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Board createProjectIssueBoard(Object projectIdOrPath, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
        return response.readEntity(Board.class);
    }

    public Board updateProjectIssueBoard(Object projectIdOrPath, Long boardId, String name, Boolean hideBacklogList, Boolean hideClosedList, Long assigneeId, Long milestoneId, String labels, Integer weight) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("hide_backlog_list", hideBacklogList).withParam("hide_closed_list", hideClosedList).withParam("assignee_id", assigneeId).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("weight", weight);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
        return response.readEntity(Board.class);
    }

    public void deleteProjectIssueBoard(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
    }

    public List<BoardList> getProjectIssueBoardLists(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getProjectIssueBoardLists(projectIdOrPath, boardId, this.getDefaultPerPage()).all();
    }

    public List<BoardList> getProjectIssueBoardLists(Object projectIdOrPath, Long boardId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
        return response.readEntity(new GenericType<List<BoardList>>(){});
    }

    public Pager<BoardList> getProjectIssueBoardLists(Object projectIdOrPath, Long boardId, int itemsPerPage) throws GitLabApiException {
        return new Pager<BoardList>(this, BoardList.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
    }

    public Stream<BoardList> getProjectIssueBoardsListsStream(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getProjectIssueBoardLists(projectIdOrPath, boardId, this.getDefaultPerPage()).stream();
    }

    public BoardList getProjectIssueBoardList(Object projectIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public Optional<BoardList> getOptionalProjectIssueBoardList(Object projectIdOrPath, Long boardId, Long listId) {
        try {
            return Optional.ofNullable(this.getProjectIssueBoardList(projectIdOrPath, boardId, listId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public BoardList createProjectIssueBoardList(Object projectIdOrPath, Long boardId, Long labelId, Long assigneeId, Long milestoneId, Long iterationId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("label_id", labelId).withParam("assignee_id", assigneeId).withParam("milestone_id", milestoneId).withParam("iteration_id", iterationId);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
        return response.readEntity(BoardList.class);
    }

    public BoardList updateProjectIssueBoardList(Object projectIdOrPath, Long boardId, Long listId, Integer position) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("position", position, true);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public void deleteProjectIssueBoardList(Object projectIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
    }

    public List<Board> getGroupIssueBoards(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupIssueBoards(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Board> getGroupIssueBoards(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "boards");
        return response.readEntity(new GenericType<List<Board>>(){});
    }

    public Pager<Board> getGroupIssueBoards(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Board>(this, Board.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards");
    }

    public Stream<Board> getGroupIssueBoardsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupIssueBoards(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Board getGroupIssueBoard(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId);
        return response.readEntity(Board.class);
    }

    public Optional<Board> getOptionalGroupIssueBoard(Object groupIdOrPath, Long boardId) {
        try {
            return Optional.ofNullable(this.getGroupIssueBoard(groupIdOrPath, boardId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Board createGroupIssueBoard(Object groupIdOrPath, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "boards");
        return response.readEntity(Board.class);
    }

    public Board updateGroupIssueBoard(Object groupIdOrPath, Long boardId, String name, Boolean hideBacklogList, Boolean hideClosedList, Long assigneeId, Long milestoneId, String labels, Integer weight) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("hide_backlog_list", hideBacklogList).withParam("hide_closed_list", hideClosedList).withParam("assignee_id", assigneeId).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("weight", weight);
        Response response = this.put(Response.Status.OK, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId);
        return response.readEntity(Board.class);
    }

    public void deleteGroupIssueBoard(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId);
    }

    public List<BoardList> getGroupIssueBoardLists(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        return this.getGroupIssueBoardLists(groupIdOrPath, boardId, this.getDefaultPerPage()).all();
    }

    public List<BoardList> getGroupIssueBoardLists(Object groupIdOrPath, Long boardId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId, "lists");
        return response.readEntity(new GenericType<List<BoardList>>(){});
    }

    public Pager<BoardList> getGroupIssueBoardLists(Object groupIdOrPath, Long boardId, int itemsPerPage) throws GitLabApiException {
        return new Pager<BoardList>(this, BoardList.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId, "lists");
    }

    public Stream<BoardList> getGroupIssueBoardsListsStream(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        return this.getGroupIssueBoardLists(groupIdOrPath, boardId, this.getDefaultPerPage()).stream();
    }

    public BoardList getGroupIssueBoardList(Object groupIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public Optional<BoardList> getOptionalGroupIssueBoardList(Object groupIdOrPath, Long boardId, Long listId) {
        try {
            return Optional.ofNullable(this.getGroupIssueBoardList(groupIdOrPath, boardId, listId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public BoardList createGroupIssueBoardList(Object groupIdOrPath, Long boardId, Long labelId, Long assigneeId, Long milestoneId, Long iterationId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("label_id", labelId).withParam("assignee_id", assigneeId).withParam("milestone_id", milestoneId).withParam("iteration_id", iterationId);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId, "lists");
        return response.readEntity(BoardList.class);
    }

    public BoardList updateGroupIssueBoardList(Object groupIdOrPath, Long boardId, Long listId, Integer position) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("position", position, true);
        Response response = this.putWithFormData(Response.Status.OK, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public void deleteGroupIssueBoardList(Object groupIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "boards", boardId, "lists", listId);
    }

    public List<Board> getGroupEpicBoards(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupEpicBoards(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Board> getGroupEpicBoards(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epic_boards");
        return response.readEntity(new GenericType<List<Board>>(){});
    }

    public Pager<Board> getGroupEpicBoards(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Board>(this, Board.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epic_boards");
    }

    public Stream<Board> getGroupEpicBoardsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupEpicBoards(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Board getGroupEpicBoard(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epic_boards", boardId);
        return response.readEntity(Board.class);
    }

    public Optional<Board> getOptionalGroupEpicBoard(Object groupIdOrPath, Long boardId) {
        try {
            return Optional.ofNullable(this.getGroupEpicBoard(groupIdOrPath, boardId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<BoardList> getGroupEpicBoardLists(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        return this.getGroupEpicBoardLists(groupIdOrPath, boardId, this.getDefaultPerPage()).all();
    }

    public List<BoardList> getGroupEpicBoardLists(Object groupIdOrPath, Long boardId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epic_boards", boardId, "lists");
        return response.readEntity(new GenericType<List<BoardList>>(){});
    }

    public Pager<BoardList> getGroupEpicBoardLists(Object groupIdOrPath, Long boardId, int itemsPerPage) throws GitLabApiException {
        return new Pager<BoardList>(this, BoardList.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epic_boards", boardId, "lists");
    }

    public Stream<BoardList> getGroupEpicBoardsListsStream(Object groupIdOrPath, Long boardId) throws GitLabApiException {
        return this.getGroupEpicBoardLists(groupIdOrPath, boardId, this.getDefaultPerPage()).stream();
    }

    public BoardList getGroupEpicBoardList(Object groupIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epic_boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public Optional<BoardList> getOptionalGroupEpicBoardList(Object groupIdOrPath, Long boardId, Long listId) {
        try {
            return Optional.ofNullable(this.getGroupEpicBoardList(groupIdOrPath, boardId, listId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }
}

