/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.operations;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.Redmine3ExtendedManager;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;

public class SearchAssignableUsers
extends Redmine3RestClientOperation<List<User>> {
    private final String projectKey;
    private final String namePrefix;

    public SearchAssignableUsers(RedmineManager manager, String projectKey, String namePrefix) {
        super(manager);
        this.projectKey = projectKey;
        this.namePrefix = namePrefix;
    }

    @Override
    public List<User> doIt() throws RedmineException {
        List<Membership> memberships = this.manager.getMemberships(this.projectKey);
        ArrayList<User> users = new ArrayList<User>(memberships.size());
        Map<Integer, ExtendedRole> extendedRoles = this.mapIdToExpendedRole();
        String searchedName = this.namePrefix.toLowerCase();
        for (Membership membership : memberships) {
            String fullname;
            if (membership.getUser() == null || !(fullname = membership.getUser().getFullName().toLowerCase()).startsWith(searchedName) || !this.issuesCanBeAssignedTo(membership, extendedRoles)) continue;
            users.add(membership.getUser());
        }
        return users;
    }

    private Map<Integer, ExtendedRole> mapIdToExpendedRole() throws RedmineException {
        HashMap<Integer, ExtendedRole> result = new HashMap<Integer, ExtendedRole>();
        Redmine3ExtendedManager extendedManager = (Redmine3ExtendedManager)this.manager;
        List<ExtendedRole> extendedRoles = extendedManager.getExtendedRoles();
        for (ExtendedRole role : extendedRoles) {
            result.put(role.getId(), role);
        }
        return result;
    }

    private boolean issuesCanBeAssignedTo(Membership member, Map<Integer, ExtendedRole> extendedRoles) throws RedmineException {
        List<Role> roles = member.getRoles();
        boolean result = false;
        for (Role r : roles) {
            ExtendedRole role = extendedRoles.get(r.getId());
            if (!role.isAssignable()) continue;
            result = true;
        }
        return result;
    }
}

