/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.squashtest.tm.plugin.rest.core.web.ProjectTypeFilter;

public class ProjectTypeFilterArgumentResolver
implements HandlerMethodArgumentResolver {
    private ProjectTypeFilter defaultFilter = ProjectTypeFilter.ALL;
    private String projectTypeFilter = "type";

    public boolean supportsParameter(MethodParameter parameter) {
        return ProjectTypeFilter.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String value = webRequest.getParameter(this.projectTypeFilter);
        if (value == null) {
            return this.defaultFilter;
        }
        try {
            return ProjectTypeFilter.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid value '" + value + "' for request parameter '" + this.projectTypeFilter + "'. Must be one of these values: 'all', 'standard', 'template'");
        }
    }

    public ProjectTypeFilter getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(ProjectTypeFilter defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public String getProjectTypeFilter() {
        return this.projectTypeFilter;
    }

    public void setProjectTypeFilter(String projectTypeFilter) {
        this.projectTypeFilter = projectTypeFilter;
    }
}

