/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import jiracloud.org.apache.http.HttpConnection;
import jiracloud.org.apache.http.HttpException;
import jiracloud.org.apache.http.HttpHost;
import jiracloud.org.apache.http.HttpInetConnection;
import jiracloud.org.apache.http.HttpRequest;
import jiracloud.org.apache.http.HttpRequestInterceptor;
import jiracloud.org.apache.http.HttpVersion;
import jiracloud.org.apache.http.ProtocolException;
import jiracloud.org.apache.http.ProtocolVersion;
import jiracloud.org.apache.http.annotation.Contract;
import jiracloud.org.apache.http.annotation.ThreadingBehavior;
import jiracloud.org.apache.http.protocol.HttpContext;
import jiracloud.org.apache.http.protocol.HttpCoreContext;
import jiracloud.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

