/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.service.RestExploratoryExecutionService;
import org.squashtest.tm.plugin.rest.service.RestExploratorySessionService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;

@RestApiController(value=ExploratorySessionOverview.class)
@UseDefaultRestApiConfiguration
public class RestExploratorySessionController
extends BaseRestController {
    public static final String EXPLO_SESSION_DYNAMIC_FILTER = "*, iteration_test_plan_item[execution_status,created_on,created_by,last_modified_on,last_modified_by,executions[last_executed_on,assignee_user,task_division,reviewed]]";
    @Inject
    private RestExploratorySessionService service;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestIssueService restIssueService;
    @Inject
    private RestExploratoryExecutionService exploratoryExecutionService;

    @GetMapping(value={"/exploratory-sessions/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, iteration_test_plan_item[execution_status,created_on,created_by,last_modified_on,last_modified_by,executions[last_executed_on,assignee_user,task_division,reviewed]]")
    public ResponseEntity<EntityModel<ExploratorySessionOverview>> findExploratorySession(@PathVariable(value="id") long id) {
        ExploratorySessionOverview exploSessionOverview = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)exploSessionOverview);
        this.linksHelper.addAllLinksForExploratorySessionOverview((EntityModel<ExploratorySessionOverview>)res);
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/exploratory-sessions/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="exploratory-executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findExploratorySessionIssues(@PathVariable(value="id") long id, Pageable pageable) {
        ExploratorySessionOverview sessionOverview = this.service.getOne(id);
        Page<ExploratoryExecution> exploratoryExecution = this.service.findExploratoryExecutionsByItpiId(sessionOverview.getTestPlanItem().getId(), pageable);
        List<Long> exploratoryExecutionList = exploratoryExecution.getContent().stream().map(Execution::getId).toList();
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(exploratoryExecutionList, pageable);
        for (IssueDto issue : pagedIssue.getContent()) {
            List<ExploratoryExecution> exploratoryExecutions = this.exploratoryExecutionService.getExploratoryExecutionFromIssues(issue.getRemoteIssueId(), exploratoryExecutionList);
            issue.setExploratoryExecutions(new HashSet<ExploratoryExecution>(exploratoryExecutions));
            issue.getExecutions().clear();
        }
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

